/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.common.MenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;

public class ExtBasicMenuUI
extends BasicMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private MenuItemRenderer renderer;
    private MouseListener mouseListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ExtBasicMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        }
        this.renderer = new MenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer n = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = n != null ? n : 2;
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        if (this.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            return this.renderer.getPreferredMenuItemSize(jComponent, icon, icon2, n);
        }
        return super.getPreferredMenuItemSize(jComponent, icon, icon2, n);
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        if (this.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
        } else {
            super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
        }
    }

    private void ensureSubMenuInstalled() {
        if (this.propertyPrefix.equals(SUBMENU_PROPERTY_PREFIX)) {
            return;
        }
        this.uninstallRolloverListener();
        this.uninstallDefaults();
        this.propertyPrefix = SUBMENU_PROPERTY_PREFIX;
        this.installDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseListener = this.createRolloverListener();
        this.menuItem.addMouseListener(this.mouseListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.uninstallRolloverListener();
    }

    private void uninstallRolloverListener() {
        if (this.mouseListener != null) {
            this.menuItem.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    protected MouseListener createRolloverListener() {
        return new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.getModel().setRollover(true);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.getModel().setRollover(false);
            }
        };
    }

    private boolean isSubMenu(JMenuItem jMenuItem) {
        return !((JMenu)jMenuItem).isTopLevelMenu();
    }
}

