/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

final class PlasticComboBoxButton
extends JButton {
    private static final int LEFT_INSET = 2;
    private static final int RIGHT_INSET = 3;
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private JComboBox comboBox;
    private Icon comboIcon;
    protected boolean iconOnly = false;
    private boolean borderPaintsFocus;

    PlasticComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        super("");
        this.setModel(new DefaultButtonModel(){

            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() || bl);
            }
        });
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.iconOnly = bl;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(jComboBox.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(jComboBox.isEnabled());
        this.setBorder(UIManager.getBorder("ComboBox.arrowButtonBorder"));
        this.setMargin(new Insets(0, 2, 0, 3));
        this.borderPaintsFocus = UIManager.getBoolean("ComboBox.borderPaintsFocus");
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public Icon getComboIcon() {
        return this.comboIcon;
    }

    public void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public boolean isIconOnly() {
        return this.iconOnly;
    }

    public void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.comboBox)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.comboBox)) {
            return false;
        }
        return PlasticUtils.is3D("ComboBox.");
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        super.paintComponent(graphics);
        boolean bl = PlasticUtils.isLeftToRight(this.comboBox);
        Insets insets = this.getInsets();
        int n6 = this.getWidth() - (insets.left + insets.right);
        int n7 = this.getHeight() - (insets.top + insets.bottom);
        if (n7 <= 0 || n6 <= 0) {
            return;
        }
        int n8 = insets.left;
        int n9 = insets.top;
        int n10 = n8 + (n6 - 1);
        int n11 = 0;
        int n12 = n5 = bl ? n10 : n8;
        if (this.comboIcon != null) {
            n11 = this.comboIcon.getIconWidth();
            n4 = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                n5 = (this.getWidth() - n11) / 2;
                n3 = (this.getHeight() - n4) / 2;
            } else {
                n5 = bl ? n8 + (n6 - 1) - n11 : n8;
                n3 = (this.getHeight() - n4) / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n5, n3);
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            n3 = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, n3 != 0, false);
            component.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("Button.select"));
                }
                component.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                component.setForeground(this.comboBox.getForeground());
                component.setBackground(this.comboBox.getBackground());
            }
            n2 = n6 - (insets.right + n11);
            n = component instanceof JPanel;
            int n13 = bl ? n8 : n8 + n11;
            int n14 = this.getHeight() - 2 - 3 - 1;
            if (!this.is3D()) {
                this.rendererPane.paintComponent(graphics, component, this, n13, n9 + 2, n2, n14, n != 0);
            } else if (!(component instanceof JComponent)) {
                this.rendererPane.paintComponent(graphics, component, this, n13, n9 + 2, n2, n14, n != 0);
            } else if (!component.isOpaque()) {
                this.rendererPane.paintComponent(graphics, component, this, n13, n9 + 2, n2, n14, n != 0);
            } else {
                JComponent jComponent = (JComponent)component;
                boolean bl2 = jComponent.isOpaque();
                jComponent.setOpaque(false);
                this.rendererPane.paintComponent(graphics, component, this, n13, n9 + 2, n2, n14, n != 0);
                jComponent.setOpaque(bl2);
            }
        }
        if (this.comboIcon != null) {
            n4 = this.comboBox.hasFocus() ? 1 : 0;
            if (!this.borderPaintsFocus && n4 != 0) {
                graphics.setColor(PlasticLookAndFeel.getFocusColor());
                n3 = 2;
                int n15 = 2;
                n2 = this.getWidth() - 2 - 3;
                n = this.getHeight() - 2 - 3;
                graphics.drawRect(n3, n15, n2 - 1, n - 1);
            }
        }
    }
}

