/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.FontSizeHints;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.SkyBluerTahoma;
import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class PlasticLookAndFeel
extends MetalLookAndFeel {
    public static final String BORDER_STYLE_KEY = "Plastic.borderStyle";
    public static final String IS_3D_KEY = "Plastic.is3D";
    public static final String DEFAULT_THEME_KEY = "Plastic.defaultTheme";
    public static final String HIGH_CONTRAST_FOCUS_ENABLED_KEY = "Plastic.highContrastFocus";
    protected static final String TAB_STYLE_KEY = "Plastic.tabStyle";
    public static final String TAB_STYLE_DEFAULT_VALUE = "default";
    public static final String TAB_STYLE_METAL_VALUE = "metal";
    private static boolean useMetalTabs = LookUtils.getSystemProperty("Plastic.tabStyle", "").equalsIgnoreCase("metal");
    public static boolean useHighContrastFocusColors = LookUtils.getSystemProperty("Plastic.highContrastFocus") != null;
    private static List installedThemes;
    private static PlasticTheme myCurrentTheme;
    private static boolean is3DEnabled;
    private static FontSizeHints fontSizeHints;
    private static final String THEME_CLASSNAME_PREFIX = "com.jgoodies.looks.plastic.theme.";

    public PlasticLookAndFeel() {
        if (null == myCurrentTheme) {
            PlasticLookAndFeel.setMyCurrentTheme(PlasticLookAndFeel.createMyDefaultTheme());
        }
    }

    public String getID() {
        return "Plastic";
    }

    public String getName() {
        return "Plastic";
    }

    public String getDescription() {
        return "The JGoodies Plastic Look and Feel - \u00a9 2001-2005 JGoodies Karsten Lentzsch";
    }

    public static FontSizeHints getFontSizeHints() {
        return fontSizeHints != null ? fontSizeHints : Options.getGlobalFontSizeHints();
    }

    public static void setFontSizeHints(FontSizeHints fontSizeHints) {
        PlasticLookAndFeel.fontSizeHints = fontSizeHints;
    }

    protected boolean is3DEnabled() {
        return is3DEnabled;
    }

    public static void set3DEnabled(boolean bl) {
        is3DEnabled = bl;
    }

    public static String getTabStyle() {
        return useMetalTabs ? TAB_STYLE_METAL_VALUE : TAB_STYLE_DEFAULT_VALUE;
    }

    public static void setTabStyle(String string) {
        useMetalTabs = string.equalsIgnoreCase(TAB_STYLE_METAL_VALUE);
    }

    public static boolean getHighContrastFocusColorsEnabled() {
        return useHighContrastFocusColors;
    }

    public static void setHighContrastFocusColorsEnabled(boolean bl) {
        useHighContrastFocusColors = bl;
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "com.jgoodies.looks.plastic.Plastic";
        String string2 = "com.jgoodies.looks.common.ExtBasic";
        Object[] objectArray = new Object[]{"ButtonUI", string + "ButtonUI", "ToggleButtonUI", string + "ToggleButtonUI", "ComboBoxUI", string + "ComboBoxUI", "ScrollBarUI", string + "ScrollBarUI", "SpinnerUI", string + "SpinnerUI", "MenuBarUI", string + "MenuBarUI", "ToolBarUI", string + "ToolBarUI", "MenuUI", string + "MenuUI", "MenuItemUI", string2 + "MenuItemUI", "CheckBoxMenuItemUI", string2 + "CheckBoxMenuItemUI", "RadioButtonMenuItemUI", string2 + "RadioButtonMenuItemUI", "PopupMenuSeparatorUI", string2 + "PopupMenuSeparatorUI", "OptionPaneUI", string + "OptionPaneUI", "ScrollPaneUI", string + "ScrollPaneUI", "SplitPaneUI", string + "SplitPaneUI", "TreeUI", string + "TreeUI", "InternalFrameUI", string + "InternalFrameUI", "SeparatorUI", string + "SeparatorUI", "ToolBarSeparatorUI", string + "ToolBarSeparatorUI"};
        uIDefaults.putDefaults(objectArray);
        if (!useMetalTabs) {
            uIDefaults.put("TabbedPaneUI", string + "TabbedPaneUI");
        }
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        Border border = PlasticBorders.getButtonBorder();
        Border border2 = PlasticBorders.getMenuItemBorder();
        Border border3 = PlasticBorders.getTextFieldBorder();
        Border border4 = PlasticBorders.getToggleButtonBorder();
        Border border5 = PlasticBorders.getPopupMenuBorder();
        Border border6 = PlasticBorders.getScrollPaneBorder();
        BorderUIResource borderUIResource = new BorderUIResource((Border)uIDefaults.get("TableHeader.cellBorder"));
        BasicBorders.MarginBorder marginBorder2 = marginBorder;
        Border border7 = PlasticBorders.getSeparatorBorder();
        Border border8 = PlasticBorders.getEtchedBorder();
        Border border9 = PlasticBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder marginBorder3 = marginBorder;
        Border border10 = PlasticBorders.getSeparatorBorder();
        Border border11 = PlasticBorders.getEtchedBorder();
        Border border12 = PlasticBorders.getToolBarHeaderBorder();
        BorderUIResource borderUIResource2 = PlasticLookAndFeel.getInternalFrameBorder();
        BorderUIResource borderUIResource3 = PlasticLookAndFeel.getPaletteBorder();
        Color color = uIDefaults.getColor("control");
        Icon icon = PlasticIconFactory.getCheckBoxIcon();
        InsetsUIResource insetsUIResource = new InsetsUIResource(2, 0, 2, 1);
        Insets insets = LookUtils.createButtonMargin(false);
        Insets insets2 = LookUtils.createButtonMargin(true);
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(1, 2, 1, 2);
        InsetsUIResource insetsUIResource3 = new InsetsUIResource(2, 3, 1, 2);
        InsetsUIResource insetsUIResource4 = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(3, 0, 3, 0) : new InsetsUIResource(2, 0, 2, 0);
        InsetsUIResource insetsUIResource5 = new InsetsUIResource(2, 4, 2, 4);
        MinimumSizedIcon minimumSizedIcon = new MinimumSizedIcon();
        Icon icon2 = PlasticIconFactory.getCheckBoxMenuItemIcon();
        Icon icon3 = PlasticIconFactory.getRadioButtonMenuItemIcon();
        Color color2 = uIDefaults.getColor("MenuItem.foreground");
        int n = uIDefaults.getFont("Tree.font").getSize();
        Integer n2 = new Integer(n + 6);
        Icon icon4 = PlasticIconFactory.getExpandedTreeIcon();
        Icon icon5 = PlasticIconFactory.getCollapsedTreeIcon();
        ColorUIResource colorUIResource = new ColorUIResource(Color.GRAY);
        Boolean bl = this.is3DEnabled();
        Object[] objectArray = new Object[]{"Button.border", border, "Button.margin", insets, "Button.narrowMargin", insets2, "CheckBox.margin", insetsUIResource, "CheckBox.icon", icon, "CheckBoxMenuItem.border", border2, "CheckBoxMenuItem.margin", insetsUIResource4, "CheckBoxMenuItem.checkIcon", icon2, "CheckBoxMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "CheckBoxMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "CheckBoxMenuItem.acceleratorForeground", color2, "CheckBoxMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "ComboBox.selectionForeground", PlasticLookAndFeel.getMenuSelectedForeground(), "ComboBox.selectionBackground", PlasticLookAndFeel.getMenuSelectedBackground(), "ComboBox.arrowButtonBorder", PlasticBorders.getComboBoxArrowButtonBorder(), "ComboBox.editorBorder", PlasticBorders.getComboBoxEditorBorder(), "ComboBox.editorColumns", new Integer(5), "EditorPane.margin", insetsUIResource3, "InternalFrame.border", borderUIResource2, "InternalFrame.paletteBorder", borderUIResource3, "List.font", PlasticLookAndFeel.getControlTextFont(), "Menu.border", PlasticBorders.getMenuBorder(), "Menu.margin", insetsUIResource5, "Menu.arrowIcon", PlasticIconFactory.getMenuArrowIcon(), "MenuBar.emptyBorder", marginBorder2, "MenuBar.separatorBorder", border7, "MenuBar.etchedBorder", border8, "MenuBar.headerBorder", border9, "MenuItem.border", border2, "MenuItem.checkIcon", minimumSizedIcon, "MenuItem.margin", insetsUIResource4, "MenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "MenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "MenuItem.acceleratorForeground", color2, "MenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "OptionPane.errorIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Error.png"), "OptionPane.informationIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Inform.png"), "OptionPane.warningIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Warn.png"), "OptionPane.questionIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Question.png"), "FileView.computerIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Computer.gif"), "FileView.directoryIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "FileView.fileIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/File.gif"), "FileView.floppyDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.gif"), "FileView.hardDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.gif"), "FileChooser.homeFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HomeFolder.gif"), "FileChooser.newFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/NewFolder.gif"), "FileChooser.upFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/UpFolder.gif"), "Tree.closedIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "Tree.openIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeOpen.gif"), "Tree.leafIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeLeaf.gif"), "FormattedTextField.border", border3, "FormattedTextField.margin", insetsUIResource2, "PasswordField.border", border3, "PasswordField.margin", insetsUIResource2, "PopupMenu.border", border5, "PopupMenuSeparator.margin", new InsetsUIResource(3, 4, 3, 4), "RadioButton.margin", insetsUIResource, "RadioButtonMenuItem.border", border2, "RadioButtonMenuItem.checkIcon", icon3, "RadioButtonMenuItem.margin", insetsUIResource4, "RadioButtonMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "RadioButtonMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "RadioButtonMenuItem.acceleratorForeground", color2, "RadioButtonMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "Separator.foreground", PlasticLookAndFeel.getControlDarkShadow(), "ScrollPane.border", border6, "ScrollPane.etchedBorder", border6, "SimpleInternalFrame.activeTitleForeground", PlasticLookAndFeel.getSimpleInternalFrameForeground(), "SimpleInternalFrame.activeTitleBackground", PlasticLookAndFeel.getSimpleInternalFrameBackground(), "Spinner.border", PlasticBorders.getFlush3DBorder(), "Spinner.defaultEditorInsets", insetsUIResource2, "SplitPane.dividerSize", new Integer(7), "TabbedPane.focus", PlasticLookAndFeel.getFocusColor(), "TabbedPane.tabInsets", new InsetsUIResource(1, 9, 1, 8), "Table.foreground", uIDefaults.get("textText"), "Table.gridColor", color, "Table.scrollPaneBorder", border6, "TableHeader.cellBorder", borderUIResource, "TextArea.margin", insetsUIResource3, "TextField.border", border3, "TextField.margin", insetsUIResource2, "TitledBorder.font", PlasticLookAndFeel.getTitleTextFont(), "TitledBorder.titleColor", PlasticLookAndFeel.getTitleTextColor(), "ToggleButton.border", border4, "ToggleButton.margin", insets, "ToggleButton.narrowMargin", insets2, "ToolBar.emptyBorder", marginBorder3, "ToolBar.separatorBorder", border10, "ToolBar.etchedBorder", border11, "ToolBar.headerBorder", border12, "ToolTip.hideAccelerator", Boolean.TRUE, "Tree.expandedIcon", icon4, "Tree.collapsedIcon", icon5, "Tree.line", colorUIResource, "Tree.hash", colorUIResource, "Tree.rowHeight", n2, "Button.is3DEnabled", bl, "ComboBox.is3DEnabled", bl, "MenuBar.is3DEnabled", bl, "ToolBar.is3DEnabled", bl, "ScrollBar.is3DEnabled", bl, "ToggleButton.is3DEnabled", bl, "CheckBox.border", marginBorder, "RadioButton.border", marginBorder, "ProgressBar.selectionForeground", PlasticLookAndFeel.getSystemTextColor(), "ProgressBar.selectionBackground", PlasticLookAndFeel.getSystemTextColor()};
        uIDefaults.putDefaults(objectArray);
        String string = "/javax/swing/plaf/metal/";
        Object[] objectArray2 = (Object[])uIDefaults.get("AuditoryCues.allAuditoryCues");
        if (objectArray2 != null) {
            Object[] objectArray3 = new String[objectArray2.length * 2];
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object;
                objectArray3[2 * i] = object = objectArray2[i];
                objectArray3[2 * i + 1] = string + uIDefaults.getString(object);
            }
            uIDefaults.putDefaults(objectArray3);
        }
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        uIDefaults.put("unifiedControlShadow", uIDefaults.getColor("controlDkShadow"));
        uIDefaults.put("primaryControlHighlight", PlasticLookAndFeel.getPrimaryControlHighlight());
    }

    public static PlasticTheme createMyDefaultTheme() {
        PlasticTheme plasticTheme;
        String string = "SkyBluerTahoma";
        String string2 = LookUtils.getSystemProperty(DEFAULT_THEME_KEY, "");
        boolean bl = string2.length() > 0;
        String string3 = bl ? string2 : string;
        PlasticTheme plasticTheme2 = PlasticLookAndFeel.createTheme(string3);
        PlasticTheme plasticTheme3 = plasticTheme = plasticTheme2 != null ? plasticTheme2 : new SkyBluerTahoma();
        if (bl) {
            String string4 = plasticTheme2.getClass().getName().substring(THEME_CLASSNAME_PREFIX.length());
            if (string4.equals(string2)) {
                LookUtils.log("I have successfully installed the '" + plasticTheme2.getName() + "' theme.");
            } else {
                LookUtils.log("I could not install the Plastic theme '" + string2 + "'.");
                LookUtils.log("I have installed the '" + plasticTheme2.getName() + "' theme, instead.");
            }
        }
        return plasticTheme;
    }

    public static List getInstalledThemes() {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        Collections.sort(installedThemes, new Comparator(){

            public int compare(Object object, Object object2) {
                MetalTheme metalTheme = (MetalTheme)object;
                MetalTheme metalTheme2 = (MetalTheme)object2;
                return metalTheme.getName().compareTo(metalTheme2.getName());
            }
        });
        return installedThemes;
    }

    protected static void installDefaultThemes() {
        installedThemes = new ArrayList();
        String[] stringArray = new String[]{"BrownSugar", "DarkStar", "DesertBlue", "DesertBluer", "DesertGreen", "DesertRed", "DesertYellow", "ExperienceBlue", "ExperienceGreen", "Silver", "SkyBlue", "SkyBluer", "SkyBluerTahoma", "SkyGreen", "SkyKrupp", "SkyPink", "SkyRed", "SkyYellow"};
        for (int i = stringArray.length - 1; i >= 0; --i) {
            PlasticLookAndFeel.installTheme(PlasticLookAndFeel.createTheme(stringArray[i]));
        }
    }

    protected static PlasticTheme createTheme(String string) {
        String string2 = THEME_CLASSNAME_PREFIX + string;
        try {
            Class<?> clazz = Class.forName(string2);
            return (PlasticTheme)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        LookUtils.log("Can't create theme " + string2);
        return null;
    }

    public static void installTheme(PlasticTheme plasticTheme) {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        installedThemes.add(plasticTheme);
    }

    public static PlasticTheme getMyCurrentTheme() {
        return myCurrentTheme;
    }

    public static void setMyCurrentTheme(PlasticTheme plasticTheme) {
        myCurrentTheme = plasticTheme;
        PlasticLookAndFeel.setCurrentTheme(plasticTheme);
    }

    public static BorderUIResource getInternalFrameBorder() {
        return new BorderUIResource(PlasticBorders.getInternalFrameBorder());
    }

    public static BorderUIResource getPaletteBorder() {
        return new BorderUIResource(PlasticBorders.getPaletteBorder());
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return PlasticLookAndFeel.getMyCurrentTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return PlasticLookAndFeel.getMyCurrentTheme().getPrimaryControlHighlight();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return PlasticLookAndFeel.getMyCurrentTheme().getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return PlasticLookAndFeel.getMyCurrentTheme().getPrimaryControlShadow();
    }

    public static ColorUIResource getPrimaryControl() {
        return PlasticLookAndFeel.getMyCurrentTheme().getPrimaryControl();
    }

    public static ColorUIResource getControlHighlight() {
        return PlasticLookAndFeel.getMyCurrentTheme().getControlHighlight();
    }

    public static ColorUIResource getControlDarkShadow() {
        return PlasticLookAndFeel.getMyCurrentTheme().getControlDarkShadow();
    }

    public static ColorUIResource getControl() {
        return PlasticLookAndFeel.getMyCurrentTheme().getControl();
    }

    public static ColorUIResource getFocusColor() {
        return PlasticLookAndFeel.getMyCurrentTheme().getFocusColor();
    }

    public static ColorUIResource getMenuItemBackground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getMenuItemBackground();
    }

    public static ColorUIResource getMenuItemSelectedBackground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getMenuItemSelectedBackground();
    }

    public static ColorUIResource getMenuItemSelectedForeground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getMenuItemSelectedForeground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getWindowTitleInactiveForeground();
    }

    public static ColorUIResource getSimpleInternalFrameForeground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getSimpleInternalFrameForeground();
    }

    public static ColorUIResource getSimpleInternalFrameBackground() {
        return PlasticLookAndFeel.getMyCurrentTheme().getSimpleInternalFrameBackground();
    }

    public static ColorUIResource getTitleTextColor() {
        return PlasticLookAndFeel.getMyCurrentTheme().getTitleTextColor();
    }

    public static FontUIResource getTitleTextFont() {
        return PlasticLookAndFeel.getMyCurrentTheme().getTitleTextFont();
    }

    static {
        is3DEnabled = false;
    }
}

