/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.windows.WindowsArrowButton;
import com.jgoodies.looks.windows.WindowsComboBoxEditor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public final class WindowsComboBoxUI
extends com.sun.java.swing.plaf.windows.WindowsComboBoxUI {
    private static final JTextField phantom = new JTextField("Phantom");

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        Dimension dimension2 = phantom.getMinimumSize();
        return new Dimension(dimension.width, Math.max(dimension2.height, dimension.height));
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor.UIResource();
    }

    protected LayoutManager createLayoutManager() {
        return new WindowsComboBoxLayoutManager();
    }

    protected JButton createArrowButton() {
        return LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? super.createArrowButton() : new WindowsArrowButton(5);
    }

    protected Rectangle rectangleForCurrentValue() {
        if (this.comboBox.isEditable() || !this.comboBox.isEnabled()) {
            return super.rectangleForCurrentValue();
        }
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        Insets insets2 = UIManager.getInsets("ComboBox.rendererMargin");
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left + insets2.left, insets.top + insets2.top, n - (insets.left + insets2.left + insets.right + insets2.right + n3), n2 - (insets.top + insets2.top + insets.bottom + insets2.bottom));
        }
        return new Rectangle(insets.left + insets2.left + n3, insets.top + insets2.top, n - (insets.left + insets2.left + insets.right + insets2.right + n3), n2 - (insets.top + insets2.top + insets.bottom + insets2.bottom));
    }

    private class WindowsComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private WindowsComboBoxLayoutManager() {
            super((BasicComboBoxUI)((Object)WindowsComboBoxUI.this));
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = WindowsComboBoxUI.this.getInsets();
            int n3 = UIManager.getInt("ScrollBar.width");
            int n4 = n2 - (insets.top + insets.bottom);
            if (WindowsComboBoxUI.this.arrowButton != null) {
                if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    WindowsComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n4);
                } else {
                    WindowsComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n3, n4);
                }
            }
            if (WindowsComboBoxUI.this.editor != null) {
                WindowsComboBoxUI.this.editor.setBounds(WindowsComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

