/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.sun.java.swing.plaf.windows.WindowsTableHeaderUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class WindowsXPTableHeaderUI
extends WindowsTableHeaderUI {
    private TableCellRenderer xpRenderer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsXPTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.xpRenderer = this.header.getDefaultRenderer();
    }

    public void uninstallUI(JComponent jComponent) {
        this.xpRenderer = null;
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (tableColumnModel.getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        int n4 = tableColumnModel.getColumnMargin();
        Rectangle rectangle2 = this.header.getHeaderRect(n2);
        if (bl) {
            for (n = n2; n <= n3; ++n) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                int n5 = tableColumn2.getWidth();
                rectangle2.width = n5 - n4;
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n5;
            }
        } else {
            int n6;
            TableColumn tableColumn3 = tableColumnModel.getColumn(n2);
            if (tableColumn3 != tableColumn) {
                n6 = tableColumn3.getWidth();
                rectangle2.width = n6 - n4;
                rectangle2.x += n4;
                this.paintCell(graphics, rectangle2, n2);
            }
            for (n = n2 + 1; n <= n3; ++n) {
                tableColumn3 = tableColumnModel.getColumn(n);
                n6 = tableColumn3.getWidth();
                rectangle2.width = n6 - n4;
                rectangle2.x -= n6;
                if (tableColumn3 == tableColumn) continue;
                this.paintCell(graphics, rectangle2, n);
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n);
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        JTable jTable = this.header.getTable();
        Component component = this.xpRenderer.getTableCellRendererComponent(jTable, null, false, false, -1, n);
        Component component2 = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, n);
        if (component2 != component) {
            boolean bl;
            this.rendererPane.add(component2);
            boolean bl2 = bl = !component2.isOpaque();
            if (bl) {
                this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                if (component2 instanceof JComponent && component instanceof JComponent) {
                    ((JComponent)component2).setBorder(((JComponent)component).getBorder());
                }
            }
        }
        this.rendererPane.paintComponent(graphics, component2, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = tableColumnModel.getColumnCount() - 1; i >= 0; --i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }
}

