/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.convenience.DefaultAboutToolPanel;
import com.jgoodies.uifextras.convenience.SystemTable;
import com.jgoodies.uifextras.panel.HeaderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DefaultAboutDialog
extends AbstractDialog {
    protected final JComponent toolTab;

    public DefaultAboutDialog(Frame frame) {
        this(frame, DefaultAboutDialog.buildDefaultToolTab());
    }

    public DefaultAboutDialog(Frame frame, JComponent jComponent) {
        super(frame);
        this.toolTab = jComponent;
    }

    private static JComponent buildDefaultToolTab() {
        DefaultAboutToolPanel defaultAboutToolPanel = new DefaultAboutToolPanel();
        defaultAboutToolPanel.build();
        return defaultAboutToolPanel;
    }

    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildTabbedPane(), "Center");
        jPanel.add((Component)this.buildButtonBarWithClose(), "South");
        return jPanel;
    }

    protected JComponent buildHeader() {
        return new HeaderPanel("About " + Application.getDescription().getName(), "You can click on the tabs below to see information\nabout ECMLink's version and the system's state.", ResourceUtils.getIcon((String)"aboutDialog.icon"));
    }

    protected JComponent buildTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Tool", this.toolTab);
        jTabbedPane.add("System", this.buildSystemTab());
        return jTabbedPane;
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.ONE2ONE.resizeDialogContent(jComponent);
    }

    protected JComponent buildSystemTab() {
        SystemTable systemTable = new SystemTable();
        int n = Sizes.dialogUnitXAsPixel((int)80, (Component)systemTable);
        systemTable.setPreferredSize(Resizer.DEFAULT.fromWidth(n));
        systemTable.setBorder(Borders.DIALOG_BORDER);
        systemTable.setOpaque(false);
        return systemTable;
    }
}

