/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.help.HelpBroker;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DefaultAboutToolPanel
extends JPanel {
    private JComponent productLabel;
    private JComponent versionLabel;
    private JComponent copyrightText;
    private JButton licenseButton;

    protected void initComponents() {
        this.productLabel = UIFactory.createBoldLabel(Application.getDescription().getProductText());
        this.versionLabel = UIFactory.createMultilineLabel(this.getVersionText());
        this.copyrightText = UIFactory.createWrappedMultilineLabel(ResourceUtils.getString((String)"aboutDialog.copyright.text"));
        this.licenseButton = this.createShowLicenseButton();
    }

    public void build() {
        this.initComponents();
        FormLayout formLayout = new FormLayout("left:pref:grow", "pref, pref, 14dlu, min, 2dlu, pref, 14dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.getPanel().setPreferredSize(Resizer.DEFAULT.fromWidth(410));
        panelBuilder.setBorder(Borders.DLU14_BORDER);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.productLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.versionLabel, cellConstraints.xy(1, 2));
        panelBuilder.add((Component)this.copyrightText, cellConstraints.xy(1, 4, "fill,  top"));
        panelBuilder.add((Component)this.licenseButton, cellConstraints.xy(1, 6, "right, top"));
        panelBuilder.add((Component)this.buildAcknowledgementsPanel(), cellConstraints.xy(1, 8, "fill,  top"));
    }

    protected JButton createShowLicenseButton() {
        JButton jButton = new JButton("Show License");
        jButton.setMnemonic('S');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((AbstractDialog)SwingUtilities.getWindowAncestor(DefaultAboutToolPanel.this)).close();
                HelpBroker.openURL(DefaultAboutToolPanel.this.getLicenseAgreementURL());
            }
        });
        return jButton;
    }

    protected JComponent buildAcknowledgementsPanel() {
        return UIFactory.createPlainLabel(this.getAcknowledgementsText());
    }

    protected String getAcknowledgementsText() {
        return ResourceUtils.getString((String)"aboutDialog.acknowledgements.text");
    }

    private String getVersionText() {
        Object object;
        String string = Application.getDescription().getVendorURL();
        try {
            object = new URL(string);
            string = ((URL)object).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger("About").warning("Malformed vendor URL" + string);
        }
        object = Application.getDescription().getCopyrightAndVendor();
        return "Copyright " + (String)object + ", " + string;
    }

    protected URL getLicenseAgreementURL() {
        String string = ResourceUtils.getString((String)"license.agreement.path");
        return ResourceUtils.getURL((String)string);
    }
}

