/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.component.UIFButton;
import com.jgoodies.uif.panel.CardPanel;
import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.Modes;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.convenience.SetupLicensePanel;
import com.jgoodies.uifextras.convenience.SetupManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DefaultSetupDialog
extends AbstractDialog {
    private static final int PREFERRED_WIDTH = 600;
    private static final String WELCOME_PANEL = "Welcome";
    private static final String LICENSE_PANEL = "License";
    private final JComponent welcomePanel;
    private final SetupLicensePanel licensePanel;

    public DefaultSetupDialog(JFrame jFrame, String string, JComponent jComponent, SetupLicensePanel setupLicensePanel) {
        super((Frame)jFrame, string + " Setup");
        this.welcomePanel = jComponent;
        this.licensePanel = setupLicensePanel;
    }

    protected JComponent buildContent() {
        CardPanel cardPanel = new CardPanel();
        cardPanel.add((Component)this.buildWelcomePanel(), (Object)WELCOME_PANEL);
        cardPanel.add((Component)this.buildLicensePanel(), (Object)LICENSE_PANEL);
        Dimension dimension = Resizer.DEFAULT.fromWidth(600);
        cardPanel.setMinimumSize(dimension);
        cardPanel.setPreferredSize(dimension);
        cardPanel.setSize(dimension);
        return cardPanel;
    }

    private JComponent buildWelcomePanel() {
        ((SetupManager.WizardPanel)((Object)this.welcomePanel)).build(this.buildWelcomeButtonBar());
        return this.welcomePanel;
    }

    private JComponent buildLicensePanel() {
        this.licensePanel.build(this.buildLicenseButtonBar());
        return this.licensePanel;
    }

    protected Border getDialogBorder() {
        return Borders.EMPTY_BORDER;
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.DEFAULT.resizeDialogContent(jComponent);
    }

    private JButton createBackButton() {
        JButton jButton = new JButton("< Back");
        jButton.setMnemonic('B');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultSetupDialog.this.doBack();
            }
        });
        return jButton;
    }

    private JButton createNextButton() {
        UIFButton uIFButton = new UIFButton("Next >");
        uIFButton.setMnemonic('N');
        uIFButton.setOpaqueMode((Mode)Modes.LAF_NON_AQUA);
        uIFButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultSetupDialog.this.doNext();
            }
        });
        return uIFButton;
    }

    private JComponent buildWelcomeButtonBar() {
        UIFButton uIFButton = this.createCancelButton();
        uIFButton.setOpaqueMode((Mode)Modes.LAF_NON_AQUA);
        JPanel jPanel = ButtonBarFactory.buildRightAlignedBar((JButton)this.createNextButton(), (JButton)uIFButton);
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JComponent buildLicenseButtonBar() {
        UIFButton uIFButton = this.createAcceptButton("Finish", false);
        uIFButton.setMnemonic('F');
        return ButtonBarFactory.buildRightAlignedBar((JButton)this.createBackButton(), (JButton)uIFButton, (JButton)this.createCancelButton());
    }

    public void doAccept() {
        if (this.licensePanel.licenseAccepted()) {
            super.doAccept();
            return;
        }
        if (this.licensePanel.licenseDeclined()) {
            this.doDecline();
            return;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "You must select to either accept or decline the license agreement.", this.getTitle(), 1);
    }

    protected void doCloseWindow() {
        if (LICENSE_PANEL.equals(this.getCardPanel().getVisibleChildName())) {
            this.doCancel();
        } else {
            this.doNext();
        }
    }

    public void doCancel() {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you really want to cancel the setup process?", this.getTitle(), 0);
        if (0 == n) {
            super.doCancel();
        }
    }

    private void doDecline() {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), ResourceUtils.getString((String)"license.confirmDecline.text"), this.getTitle(), 0);
        if (0 == n) {
            super.doCancel();
        }
    }

    private void doBack() {
        this.getCardPanel().showPreviousCard();
    }

    private void doNext() {
        this.getCardPanel().showNextCard();
        this.setLicensePage();
    }

    private CardPanel getCardPanel() {
        return (CardPanel)this.getContentPane();
    }

    private void setLicensePage() {
        URL uRL = this.getLicenseAgreementURL();
        try {
            this.licensePanel.setPage(uRL);
        }
        catch (IOException iOException) {
            Logger.getLogger("LicenseAcceptanceDialog").log(Level.WARNING, "Can't open URL " + uRL + ".", iOException);
        }
    }

    private URL getLicenseAgreementURL() {
        String string = ResourceUtils.getString((String)"license.agreement.path");
        return ResourceUtils.getURL((String)string);
    }
}

