/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.uif.application.Application;
import com.jgoodies.uifextras.convenience.SendFeedbackDialog;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class MessageLogHandler
extends Handler {
    private static final String OK_LABEL = "OK";
    private static final String FEEDBACK_LABEL = "Send Feedback\u2026";
    private static final Object[] OPTIONS = new Object[]{"OK", "Send Feedback\u2026"};
    private final String feedbackReceiver;

    public MessageLogHandler(String string) {
        this.feedbackReceiver = string;
    }

    public void publish(LogRecord logRecord) {
        int n = logRecord.getLevel().intValue();
        if (n < Level.WARNING.intValue()) {
            return;
        }
        String string = logRecord.getMessage();
        if (logRecord.getThrown() == null) {
            JOptionPane.showMessageDialog(this.owner(), string, this.getTitle(logRecord.getLevel()), this.getMessageType(logRecord.getLevel()));
        } else {
            this.showOptionWithFeedbackDialog(logRecord.getLevel(), string, logRecord.getThrown());
        }
    }

    public void close() {
    }

    public void flush() {
    }

    private int getMessageType(Level level) {
        if (Level.SEVERE.equals(level)) {
            return 0;
        }
        if (Level.WARNING.equals(level)) {
            return 2;
        }
        return 1;
    }

    private String getSubject(Level level) {
        return "Execution " + this.getTitle(level);
    }

    private String getTitle(Level level) {
        if (Level.SEVERE.equals(level)) {
            return "Error";
        }
        if (Level.WARNING.equals(level)) {
            return "Warning";
        }
        return "Message";
    }

    private void sendFeedback(Level level, String string, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(string);
        stringWriter.write("\n");
        this.writeSystemProperties(stringWriter, new String[]{"os.name", "os.version", "java.vm.vendor", "java.vm.version", "application.fullversion"});
        if (throwable != null) {
            stringWriter.write("\n\n");
            throwable.printStackTrace(new PrintWriter(stringWriter));
        }
        new SendFeedbackDialog(this.owner(), this.feedbackReceiver, this.getSubject(level), stringWriter.toString()).open();
    }

    private void writeSystemProperties(StringWriter stringWriter, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = System.getProperty(string);
            if (string2 == null) continue;
            stringWriter.write("\n");
            stringWriter.write(string);
            stringWriter.write("=");
            stringWriter.write(string2);
        }
    }

    private void showOptionWithFeedbackDialog(Level level, String string, Throwable throwable) {
        int n = this.getMessageType(level);
        String string2 = this.getTitle(level);
        String string3 = string + "\n" + throwable.getLocalizedMessage();
        int n2 = JOptionPane.showOptionDialog(this.owner(), string3, string2, -1, n, null, OPTIONS, OK_LABEL);
        if (n2 == 1) {
            this.sendFeedback(level, string, throwable);
        }
    }

    private Frame owner() {
        JFrame jFrame = Application.getDefaultParentFrame();
        return jFrame == null ? new Frame() : jFrame;
    }
}

