/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.panel.HeaderPanel;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public final class SendFeedbackDialog
extends AbstractDialog {
    private static final int PANEL_WIDTH = 280;
    private static final String COPY_TO_CLIPBOARD_LABEL = "Copy to Clipboard";
    private final String receiver;
    private final String subject;
    private final String mailContents;

    public SendFeedbackDialog(Frame frame, String string, String string2, String string3) {
        super(frame);
        this.receiver = string;
        this.subject = string2;
        this.mailContents = string3;
    }

    protected JComponent buildHeader() {
        return new HeaderPanel("Send Feedback: " + this.subject, "You can send feedback to help improve this tool.\nClick on the 'Contents' tab to see the mail contents.", ResourceUtils.getIcon((String)"feedbackDialog.icon"));
    }

    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildTabbedPane(), "Center");
        jPanel.add((Component)this.buildButtonBar(), "South");
        return jPanel;
    }

    protected JComponent buildTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Help", this.buildHelpTab());
        jTabbedPane.add("Mail Contents", this.buildMailContentsTab());
        return jTabbedPane;
    }

    private JPanel buildHelpTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = UIFactory.createWrappedMultilineLabel(this.getHelpContents());
        jPanel.add(jTextArea);
        jPanel.setPreferredSize(Resizer.DEFAULT.fromWidth(280));
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JPanel buildMailContentsTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(this.getContentsWithHeader());
        jTextArea.setEditable(false);
        jPanel.add(new JScrollPane(jTextArea));
        jPanel.setPreferredSize(Resizer.DEFAULT.fromWidth(280));
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JComponent buildButtonBar() {
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setDefaultButtonBarGapBorder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixedNarrow((JComponent)this.createCopyToClipboardButton());
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addGridded((JComponent)this.createCloseButton(true));
        return buttonBarBuilder.getPanel();
    }

    private JButton createCopyToClipboardButton() {
        JButton jButton = new JButton(COPY_TO_CLIPBOARD_LABEL);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(SendFeedbackDialog.this.getContentsWithHeader());
                SendFeedbackDialog.this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        });
        return jButton;
    }

    protected Border getDialogBorder() {
        return CARD_DIALOG_BORDER;
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.DEFAULT.resizeDialogContent(jComponent);
    }

    private String getHelpContents() {
        String string = ResourceUtils.getString((String)"feedbackDialog.text");
        return MessageFormat.format(string, this.receiver, this.subject);
    }

    private String getContentsWithHeader() {
        return "To: " + this.receiver + "\n" + "Subject: " + this.subject + "\n\n" + this.mailContents;
    }
}

