/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.panel.HeaderPanel;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public final class SetupLicensePanel
extends JPanel {
    private JEditorPane licensePane;
    private JRadioButton acceptRadio;
    private JRadioButton declineRadio;

    public SetupLicensePanel() {
        super(null);
        this.initComponents();
    }

    public void setPage(URL uRL) throws IOException {
        this.licensePane.setPage(uRL);
    }

    public boolean licenseAccepted() {
        return this.acceptRadio.isSelected();
    }

    public boolean licenseDeclined() {
        return this.declineRadio.isSelected();
    }

    private void initComponents() {
        this.licensePane = UIFactory.createHTMLPane(false, true);
        this.licensePane.setBackground(UIFactory.getLightBackground());
        this.licensePane.setMargin(new Insets(0, 10, 0, 5));
        this.acceptRadio = new JRadioButton("I accept the terms in the license agreement");
        this.declineRadio = new JRadioButton("I do not accept the terms in the license agreement");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.acceptRadio);
        buttonGroup.add(this.declineRadio);
    }

    public void build(JComponent jComponent) {
        jComponent.setBorder(Borders.createEmptyBorder((String)"6dlu, 6dlu, 6dlu, 6dlu"));
        FormLayout formLayout = new FormLayout("15dlu, left:min:grow, 15dlu", "pref, 17dlu, min:grow, 4dlu, pref, 2dlu, pref, 2dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildHeader(), cellConstraints.xyw(1, 1, 3));
        panelBuilder.add((Component)this.buildLicensePanel(), cellConstraints.xy(2, 3, "f, f"));
        panelBuilder.add((Component)this.acceptRadio, cellConstraints.xy(2, 5));
        panelBuilder.add((Component)this.declineRadio, cellConstraints.xy(2, 7));
        panelBuilder.add((Component)jComponent, cellConstraints.xyw(1, 9, 3));
    }

    private JComponent buildHeader() {
        return new HeaderPanel("License Agreement", ResourceUtils.getString((String)"license.header.text"), ResourceUtils.getIcon((String)"license.icon"));
    }

    private JComponent buildLicensePanel() {
        JScrollPane jScrollPane = new JScrollPane(this.licensePane);
        jScrollPane.putClientProperty("jgoodies.isEtched", Boolean.TRUE);
        KeyStroke[] keyStrokeArray = jScrollPane.getRegisteredKeyStrokes();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            ActionListener actionListener = jScrollPane.getActionForKeyStroke(keyStroke);
            jScrollPane.unregisterKeyboardAction(keyStroke);
            jScrollPane.registerKeyboardAction(actionListener, keyStroke, 2);
        }
        return jScrollPane;
    }
}

