/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.splash.Splash;
import com.jgoodies.uifextras.convenience.DefaultSetupDialog;
import com.jgoodies.uifextras.convenience.DefaultSetupWelcomePanel;
import com.jgoodies.uifextras.convenience.SetupLicensePanel;
import java.util.prefs.Preferences;
import javax.swing.JComponent;

public final class SetupManager {
    private static final String ACCEPTED_LICENSE_KEY = "setup.acceptedLicense";
    private static final String ACCEPTED_LICENSE_DEFAULT = "none";
    private static final String USAGE_COUNT_KEY = "setup.usageCount";
    private static final int INITIAL_USAGE_COUNT = 0;
    private static JComponent welcomePanel;
    private static SetupLicensePanel licensePanel;
    private static int count;

    private SetupManager() {
    }

    public static boolean hasAcceptedVersion(String string) {
        return string.equals(SetupManager.getAcceptedLicense());
    }

    public static String getAcceptedLicense() {
        return SetupManager.userPrefs().get(ACCEPTED_LICENSE_KEY, ACCEPTED_LICENSE_DEFAULT);
    }

    public static void setAcceptedLicense(String string) {
        Preferences preferences = SetupManager.userPrefs();
        preferences.put(ACCEPTED_LICENSE_KEY, string);
    }

    public static boolean checkLicense() {
        String string = Application.getDescription().getVersion();
        if (SetupManager.hasAcceptedVersion(string)) {
            return true;
        }
        Splash.ensureClosed();
        AbstractDialog abstractDialog = SetupManager.buildSetupDialog();
        abstractDialog.open();
        if (abstractDialog.hasBeenCanceled()) {
            return false;
        }
        SetupManager.setAcceptedLicense(string);
        return true;
    }

    private static AbstractDialog buildSetupDialog() {
        return new DefaultSetupDialog(Application.getDefaultParentFrame(), Application.getDescription().getName(), SetupManager.getWelcomePanel(), SetupManager.getLicensePanel());
    }

    private static JComponent getWelcomePanel() {
        if (welcomePanel == null) {
            welcomePanel = new DefaultSetupWelcomePanel();
        }
        return welcomePanel;
    }

    public static void setWelcomePanel(WizardPanel wizardPanel) {
        if (!(wizardPanel instanceof JComponent)) {
            throw new IllegalArgumentException("Welcome panel must be a JComponent.");
        }
        welcomePanel = (JComponent)((Object)wizardPanel);
    }

    private static SetupLicensePanel getLicensePanel() {
        if (licensePanel == null) {
            licensePanel = new SetupLicensePanel();
        }
        return licensePanel;
    }

    public static void setLicensePanel(SetupLicensePanel setupLicensePanel) {
        licensePanel = setupLicensePanel;
    }

    public static int usageCount() {
        if (count == -1) {
            count = SetupManager.userPrefs().getInt(USAGE_COUNT_KEY, 0);
        }
        return count;
    }

    public static void incrementUsageCounter() {
        SetupManager.userPrefs().putInt(USAGE_COUNT_KEY, ++count);
    }

    private static Preferences userPrefs() {
        return Application.getUserPreferences();
    }

    static {
        count = -1;
    }

    public static interface WizardPanel {
        public void build(JComponent var1);
    }
}

