/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.convenience;

import com.jgoodies.binding.adapter.PreferencesAdapter;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class TipOfTheDayDialog
extends AbstractDialog {
    private static final String IS_SHOWING_KEY = "tipOfTheDay.isShowing";
    private static final Boolean IS_SHOWING_DEFAULT = Boolean.TRUE;
    private static final String TIP_INDEX_KEY = "tipOfTheDay.index";
    private static final Integer TIP_INDEX_DEFAULT = new Integer(0);
    private static final Logger LOGGER = Logger.getLogger("TipOfTheDayDialog");
    private static PreferencesAdapter showingTipsModel;
    private static PreferencesAdapter tipIndexModel;
    private JEditorPane htmlPane;
    private List tipPaths;

    public TipOfTheDayDialog(Frame frame, String string) {
        super(frame, "Tip of the Day");
        tipIndexModel = new PreferencesAdapter(Application.getUserPreferences(), TIP_INDEX_KEY, (Object)TIP_INDEX_DEFAULT);
        this.readTipPaths(string);
    }

    public static boolean isShowingTips() {
        return TipOfTheDayDialog.showingTipsModel().getBoolean();
    }

    public static void setShowingTips(boolean bl) {
        TipOfTheDayDialog.showingTipsModel().setBoolean(bl);
    }

    public static PreferencesAdapter showingTipsModel() {
        if (showingTipsModel == null) {
            showingTipsModel = new PreferencesAdapter(Application.getUserPreferences(), IS_SHOWING_KEY, (Object)IS_SHOWING_DEFAULT);
        }
        return showingTipsModel;
    }

    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildMainPanel(), "Center");
        jPanel.add((Component)this.buildButtonBar(), "South");
        return jPanel;
    }

    private JPanel buildMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.htmlPane = UIFactory.createHTMLPane(false, false);
        this.htmlPane.setMargin(new Insets(0, 10, 0, 5));
        this.goToNextTip();
        jPanel.add(new JScrollPane(this.htmlPane));
        jPanel.setPreferredSize(Resizer.DEFAULT.fromWidth(320));
        return jPanel;
    }

    private JComponent buildButtonBar() {
        JCheckBox jCheckBox = new JCheckBox("Show tips on startup");
        jCheckBox.setModel(this.createShowTipsButtonModel((ValueModel)TipOfTheDayDialog.showingTipsModel()));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setDefaultButtonBarGapBorder();
        buttonBarBuilder.addFixed((JComponent)jCheckBox);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded((JComponent)this.createBackButton());
        buttonBarBuilder.addGridded((JComponent)this.createNextButton());
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addGridded((JComponent)this.createCloseButton(true));
        return buttonBarBuilder.getPanel();
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.DEFAULT.resizeDialogContent(jComponent);
    }

    private ButtonModel createShowTipsButtonModel(ValueModel valueModel) {
        return new ToggleButtonAdapter((ValueModel)this.buffer(valueModel));
    }

    private JButton createBackButton() {
        JButton jButton = new JButton("< Back");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TipOfTheDayDialog.this.goToPreviousTip();
            }
        });
        return jButton;
    }

    private JButton createNextButton() {
        JButton jButton = new JButton("Next >");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TipOfTheDayDialog.this.goToNextTip();
            }
        });
        return jButton;
    }

    public void close() {
        this.doApply();
        super.close();
    }

    private void goToNextTip() {
        int n = tipIndexModel.getInt();
        if (++n >= this.tipPaths.size()) {
            n = 0;
        }
        tipIndexModel.setInt(n);
        this.showTip((String)this.tipPaths.get(n));
    }

    private void goToPreviousTip() {
        int n = tipIndexModel.getInt();
        if (--n < 0) {
            n = this.tipPaths.size() - 1;
        }
        tipIndexModel.setInt(n);
        this.showTip((String)this.tipPaths.get(n));
    }

    private String getDirectoryName(String string) {
        int n = string.lastIndexOf(47);
        return n == -1 ? "" : string.substring(0, n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readTipPaths(String string) {
        block19: {
            InputStream inputStream;
            block18: {
                this.tipPaths = new ArrayList();
                String string2 = this.getDirectoryName(string);
                inputStream = null;
                inputStream = ResourceUtils.getInputStream((String)string);
                if (null != inputStream) break block20;
                Object var11_4 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Could not close the file.", iOException);
                }
                {
                    String string3;
                    block20: {
                        return;
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    do {
                        if ((string3 = bufferedReader.readLine()) == null || (string3 = string3.trim()).length() <= 0) continue;
                        this.tipPaths.add(string2 + string3);
                    } while (string3 != null);
                    Object var8_14 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, "Could not close the text file reader.", iOException);
                    }
                    break block18;
                    {
                        catch (IOException iOException) {
                            LOGGER.log(Level.WARNING, "Error while reading tip index file: " + string, iOException);
                            Object var8_15 = null;
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException2) {
                                LOGGER.log(Level.WARNING, "Could not close the text file reader.", iOException2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_16 = null;
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.WARNING, "Could not close the text file reader.", iOException);
                        }
                        throw throwable;
                    }
                }
            }
            Object var11_5 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block19;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Could not close the file.", iOException);
            }
            break block19;
            catch (Throwable throwable) {
                Object var11_6 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Could not close the file.", iOException);
                }
                throw throwable;
            }
        }
    }

    private void showTip(String string) {
        block2: {
            URL uRL = ResourceUtils.getURL((String)string);
            try {
                this.htmlPane.setPage(uRL);
            }
            catch (IOException iOException) {
                if (uRL == null) break block2;
                LOGGER.warning("Can't show tip URL: " + uRL);
            }
        }
    }
}

