/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.fileaccess;

import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.component.UIFTree;
import com.jgoodies.uif.lazy.Preparable;
import com.jgoodies.uif.util.Resizer;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.fileaccess.DirectoryTreeNode;
import com.jgoodies.uifextras.fileaccess.ExtFileSystemView;
import com.jgoodies.uifextras.panel.HeaderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public final class DirectoryChooser
extends AbstractDialog {
    private boolean canSelectLeafDirectory = false;
    private File selection = null;
    private JTree directoryTree;
    static /* synthetic */ Class class$java$awt$Frame;

    private DirectoryChooser(Frame frame) {
        super(frame);
    }

    public static File chooseDirectory(Component component) {
        return DirectoryChooser.chooseDirectory(component, false);
    }

    public static File chooseDirectory(Component component, boolean bl) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = DirectoryChooser.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        DirectoryChooser directoryChooser = new DirectoryChooser(frame);
        directoryChooser.setCanSelectLeafDirectory(bl);
        directoryChooser.open();
        return directoryChooser.getSelectedDirectory();
    }

    protected JComponent buildHeader() {
        return new HeaderPanel("Choose Directory", "Select a directory from the list below, then click \"OK\".\nYou can expand directories by clicking on the anchors.", ResourceUtils.getIcon((String)"chooseDirectory.icon"));
    }

    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createDirectoryTreePane(), "Center");
        jPanel.add((Component)this.buildButtonBarWithOKCancel(), "South");
        this.getOKAction().setEnabled(false);
        jPanel.setPreferredSize(new Dimension(200, 310));
        return jPanel;
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.DEFAULT.resizeDialogContent(jComponent);
    }

    private JComponent createDirectoryTreePane() {
        DirectoryTreeNode directoryTreeNode = DirectoryTreeNode.createRoot();
        this.directoryTree = new UIFTree((TreeNode)directoryTreeNode);
        this.directoryTree.setRootVisible(false);
        this.directoryTree.setShowsRootHandles(true);
        this.directoryTree.getSelectionModel().setSelectionMode(1);
        if (directoryTreeNode.getChildCount() == 1) {
            this.directoryTree.expandRow(0);
        }
        this.directoryTree.setCellRenderer(new DirectoryTreeRenderer());
        this.directoryTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DirectoryChooser.this.updateOKActionEnablement((DirectoryTreeNode)treeSelectionEvent.getPath().getLastPathComponent());
            }
        });
        this.directoryTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && DirectoryChooser.this.getOKAction().isEnabled()) {
                    DirectoryChooser.this.doAccept();
                }
            }
        });
        this.directoryTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
                DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                try {
                    DirectoryChooser.this.setCursor(Cursor.getPredefinedCursor(3));
                    directoryTreeNode.loadChildren();
                }
                finally {
                    DirectoryChooser.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        return new JScrollPane(this.directoryTree);
    }

    public void close() {
        this.setVisible(false);
    }

    public void doCancel() {
        this.selection = null;
        super.doCancel();
    }

    private File getSelectedDirectory() {
        return this.selection;
    }

    public void setCanSelectLeafDirectory(boolean bl) {
        this.canSelectLeafDirectory = bl;
    }

    private void updateOKActionEnablement(DirectoryTreeNode directoryTreeNode) {
        this.selection = directoryTreeNode.getDirectory();
        boolean bl = this.canSelectLeafDirectory || directoryTreeNode.getChildCount() > 0;
        this.getOKAction().setEnabled(bl && directoryTreeNode.isFileSystem());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class EagerBuilder
    implements Preparable {
        public void prepare() {
            Logger.getLogger("DirectoryChooser").info("Preparing the directory chooser\u2026");
            new DirectoryChooser(null).build();
        }
    }

    private static class DirectoryTreeRenderer
    extends DefaultTreeCellRenderer {
        private DirectoryTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, false, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (null == object2 || !(object2 instanceof File)) {
                return this;
            }
            File file = (File)object2;
            ExtFileSystemView extFileSystemView = ExtFileSystemView.getInstance();
            this.setText(extFileSystemView.getDirectoryName(file));
            this.setIcon(extFileSystemView.getIcon(file, bl));
            return this;
        }
    }
}

