/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.fileaccess;

import com.jgoodies.uifextras.fileaccess.ExtFileSystemView;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

final class DirectoryTreeNode
extends DefaultMutableTreeNode {
    protected boolean childrenAreLoaded;
    protected boolean deferLoadingChildren;

    private DirectoryTreeNode(File file) {
        this(file, true);
    }

    private DirectoryTreeNode(File file, boolean bl) {
        super(file);
        this.childrenAreLoaded = false;
        this.deferLoadingChildren = bl;
    }

    private DirectoryTreeNode(String string, File[] fileArray) {
        super(string);
        this.addChildren(fileArray);
        this.deferLoadingChildren = true;
    }

    public static DirectoryTreeNode createRoot() {
        return new DirectoryTreeNode("Filesystem Roots", ExtFileSystemView.getInstance().getRoots());
    }

    protected void addChildren(File[] fileArray) {
        this.childrenAreLoaded = true;
        for (int i = 0; i < fileArray.length; ++i) {
            this.add(new DirectoryTreeNode(fileArray[i], true));
        }
    }

    public Enumeration children() {
        this.ensureChildrenAreLoaded();
        return super.children();
    }

    public TreeNode getChildAt(int n) {
        this.ensureChildrenAreLoaded();
        return super.getChildAt(n);
    }

    public int getChildCount() {
        this.ensureChildrenAreLoaded();
        return super.getChildCount();
    }

    public boolean isLeaf() {
        return !this.childrenAreLoaded && this.shouldDeferLoadingChildren() ? false : super.isLeaf();
    }

    private void ensureChildrenAreLoaded() {
        if (!this.childrenAreLoaded) {
            this.loadChildren();
        }
    }

    public File getDirectory() {
        return (File)this.getUserObject();
    }

    public boolean isFileSystem() {
        return ExtFileSystemView.getInstance().isFileSystem(this.getDirectory());
    }

    public void loadChildren() {
        File file;
        if (this.childrenAreLoaded) {
            return;
        }
        File file2 = this.getDirectory();
        this.childrenAreLoaded = true;
        File[] fileArray = ExtFileSystemView.getInstance().getFiles(file2, false);
        if (null == fileArray) {
            return;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            file = fileArray[i];
            if (!file.isDirectory()) continue;
            linkedList.add(file);
        }
        Collections.sort(linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            this.add(new DirectoryTreeNode(file));
        }
    }

    protected boolean shouldDeferLoadingChildren() {
        return this.deferLoadingChildren;
    }
}

