/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.fileaccess;

import com.jgoodies.uif.lazy.Preparable;
import com.jgoodies.uif.util.CompoundIcon;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uif.util.SystemUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public final class ExtFileSystemView {
    private static final String ABSENT_ICON_PATH = "com/jgoodies/common/images/Remove.gif";
    private static PropertyChangeListener lookChangeHandler;
    private static ExtFileSystemView instance;
    private Icon absentFolderIcon;
    private Icon absentLeafIcon;
    private Icon floppyDriveIcon;
    private Icon hardDriveIcon;
    private Icon homeFolderIcon;
    private Icon leafIcon;
    private JFileChooser fileChooser = new JFileChooser();
    private FileSystemView fileSystemView = this.fileChooser.getFileSystemView();

    private ExtFileSystemView() {
        this.installCachedIcons();
        ExtFileSystemView.ensureLookChangeHandlerRegistered();
    }

    public static ExtFileSystemView getInstance() {
        if (instance == null) {
            instance = new ExtFileSystemView();
        }
        return instance;
    }

    private static void ensureLookChangeHandlerRegistered() {
        if (lookChangeHandler == null) {
            lookChangeHandler = new LookAndFeelChangeHandler();
            UIManager.addPropertyChangeListener(lookChangeHandler);
        }
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public String getDirectoryName(File file) {
        return this.fileSystemView.getSystemDisplayName(file);
    }

    public File[] getFiles(File file, boolean bl) {
        return this.fileSystemView.getFiles(file, bl);
    }

    public Icon getIcon(File file, boolean bl) {
        if (!file.exists()) {
            return this.absentFolderIcon;
        }
        try {
            return this.fileChooser.getIcon(file);
        }
        catch (Exception exception) {
            return UIManager.getIcon(bl ? "Tree.openIcon" : "Tree.closedIcon");
        }
    }

    public Icon getLeafIcon(File file) {
        File file2 = file.getParentFile();
        if (file2 != null) {
            boolean bl = null == file2.getParentFile();
            String string = file.getName();
            if (bl && ("pagefile.sys".equals(string) || "hiberfil.sys".equals(string))) {
                return this.leafIcon;
            }
        }
        return !file.exists() ? this.absentLeafIcon : this.getIcon(file, false);
    }

    public File[] getRoots() {
        File[] fileArray = this.fileSystemView.getRoots();
        if (SystemUtils.IS_OS_WINDOWS) {
            return fileArray;
        }
        File[] fileArray2 = new File[fileArray.length + 1];
        System.arraycopy(fileArray, 0, fileArray2, 1, fileArray.length);
        fileArray2[0] = this.getCurrentDirectory();
        return fileArray2;
    }

    private void installCachedIcons() {
        Icon icon;
        this.leafIcon = UIManager.getIcon("FileView.fileIcon");
        if (this.leafIcon == null) {
            this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        }
        if ((icon = UIManager.getIcon("FileView.directoryIcon")) == null) {
            icon = UIManager.getIcon("Tree.closedIcon");
        }
        ImageIcon imageIcon = ResourceUtils.readImageIcon((String)ABSENT_ICON_PATH);
        this.absentFolderIcon = new CompoundIcon(icon, (Icon)imageIcon);
        this.absentLeafIcon = new CompoundIcon(this.leafIcon, (Icon)imageIcon);
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        if (null == this.hardDriveIcon) {
            this.hardDriveIcon = UIManager.getIcon("Tree.closedIcon");
        }
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        if (null == this.floppyDriveIcon) {
            this.floppyDriveIcon = this.hardDriveIcon;
        }
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        if (null == this.homeFolderIcon) {
            this.homeFolderIcon = UIManager.getIcon("Tree.closedIcon");
        }
    }

    public boolean isFileSystem(File file) {
        return this.fileSystemView.isFileSystem(file);
    }

    public static class EagerInitializer
    implements Preparable {
        public void prepare() {
            Logger.getLogger("ExtFileSystemView").info("Preparing the extended FileSytemView\u2026");
            ExtFileSystemView.getInstance();
        }
    }

    private static class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            instance = null;
        }
    }
}

