/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.help;

import com.jgoodies.uif.action.ActionManager;
import com.jgoodies.uifextras.help.HelpBroker;
import com.jgoodies.uifextras.history.History;
import com.jgoodies.uifextras.printing.PrintManager;
import com.jgoodies.uifextras.printing.PrintableDocument;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

final class HelpActions {
    static final String HELP_GO_BACK_ID = "com.jgoodies.help.goBack";
    static final String HELP_GO_NEXT_ID = "com.jgoodies.help.goNext";
    static final String HELP_GO_HOME_ID = "com.jgoodies.help.goHome";
    static final String HELP_PAGE_SETUP_ID = "com.jgoodies.help.pageSetup";
    static final String HELP_PRINT_ID = "com.jgoodies.help.print";
    static final String HELP_CLOSE_ID = "com.jgoodies.help.close";

    private HelpActions() {
    }

    static void registerActions(History history) {
        ActionManager.register((String)HELP_CLOSE_ID, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpBroker.closeViewer();
            }
        });
        ActionManager.register((String)HELP_PRINT_ID, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintableDocument.createFrom(HelpBroker.getSelectedURL()).printWithDialog();
            }
        });
        ActionManager.register((String)HELP_PAGE_SETUP_ID, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.openPageSetupDialog();
            }
        });
        ActionManager.InitializationType initializationType = ActionManager.EAGER;
        ActionManager.register((String)HELP_GO_BACK_ID, (Action)history.getGoBackAction(), (ActionManager.InitializationType)initializationType);
        ActionManager.register((String)HELP_GO_NEXT_ID, (Action)history.getGoNextAction(), (ActionManager.InitializationType)initializationType);
        ActionManager.register((String)HELP_GO_HOME_ID, (Action)history.getGoHomeAction(), (ActionManager.InitializationType)initializationType);
    }
}

