/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.help;

import com.jgoodies.uif.lazy.Preparable;
import com.jgoodies.uifextras.help.HelpModel;
import com.jgoodies.uifextras.help.HelpSet;
import com.jgoodies.uifextras.help.HelpViewer;
import java.net.URL;
import java.util.logging.Logger;

public final class HelpBroker
implements Preparable {
    private static final Logger LOGGER = Logger.getLogger("HelpBroker");
    private static String helpSetPath;
    private static HelpBroker instance;
    private final HelpModel model;
    private final HelpViewer viewer;
    static /* synthetic */ Class class$com$jgoodies$uif$util$ResourceUtils;

    HelpBroker(HelpSet helpSet) {
        this.model = new HelpModel(helpSet);
        this.viewer = new HelpViewer(this.model);
        this.viewer.build();
    }

    public static void setHelpSetPath(String string) {
        helpSetPath = string;
    }

    public static void openURL(URL uRL) {
        HelpBroker.viewer().show(uRL);
    }

    public static void openDefault() {
        HelpBroker.viewer().setDisplayed(true);
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    static URL getSelectedURL() {
        return HelpBroker.model().getSelection();
    }

    static void closeViewer() {
        HelpBroker.viewer().setVisible(false);
    }

    public static HelpBroker getInstance() {
        if (!HelpBroker.hasInstance()) {
            instance = HelpBroker.createInstance(helpSetPath);
        }
        return instance;
    }

    private static HelpBroker createInstance(String string) {
        ClassLoader classLoader = (class$com$jgoodies$uif$util$ResourceUtils == null ? (class$com$jgoodies$uif$util$ResourceUtils = HelpBroker.class$("com.jgoodies.uif.util.ResourceUtils")) : class$com$jgoodies$uif$util$ResourceUtils).getClassLoader();
        URL uRL = HelpSet.findHelpSet(classLoader, string);
        if (null == uRL) {
            LOGGER.warning("HelpSet not found.");
            return null;
        }
        HelpSet helpSet = new HelpSet(classLoader, uRL);
        HelpBroker helpBroker = helpSet.createHelpBroker();
        if (null == helpBroker) {
            LOGGER.warning("Can't create the HelpBroker.");
        }
        return helpBroker;
    }

    private static HelpViewer viewer() {
        return HelpBroker.getInstance().viewer;
    }

    private static HelpModel model() {
        return HelpBroker.getInstance().model;
    }

    public void prepare() {
        LOGGER.info("Prebuilding the help viewer\u2026");
        HelpBroker.viewer();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

