/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.help;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.uif.action.ActionManager;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uif.component.UIFMenuItem;
import com.jgoodies.uifextras.help.HelpActions;
import com.jgoodies.uifextras.help.HelpHistory;
import com.jgoodies.uifextras.help.HelpItem;
import com.jgoodies.uifextras.help.HelpSet;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

final class HelpModel
extends Model {
    static final String PROPERTYNAME_SELECTION = "selection";
    private final HelpSet helpSet;
    private final HelpHistory history;
    private final TreeModel navigationTreeModel;
    private final TreeSelectionModel navigationTreeSelectionModel;
    private URL selection;
    private MouseListener popupAdapter;

    HelpModel(HelpSet helpSet) {
        this.helpSet = helpSet;
        this.navigationTreeModel = new DefaultTreeModel(helpSet.getRoot());
        this.navigationTreeSelectionModel = new DefaultTreeSelectionModel();
        this.navigationTreeSelectionModel.setSelectionMode(1);
        this.history = new HelpHistory(helpSet.getHome());
        HelpActions.registerActions(this.history);
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.history.addPropertyChangeListener(PROPERTYNAME_SELECTION, new HistoryChangeHandler());
        this.navigationTreeSelectionModel.addTreeSelectionListener(new NavigationTreeSelectionChangeHandler());
    }

    TreeModel getNavigationTreeModel() {
        return this.navigationTreeModel;
    }

    TreeSelectionModel getNavigationTreeSelectionModel() {
        return this.navigationTreeSelectionModel;
    }

    private void setTreeSelection(URL uRL) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findNode(uRL, defaultMutableTreeNode);
        if (null == defaultMutableTreeNode2) {
            return;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
        this.navigationTreeSelectionModel.setSelectionPath(treePath);
    }

    private DefaultMutableTreeNode findNode(URL uRL, DefaultMutableTreeNode defaultMutableTreeNode) {
        HelpItem helpItem = (HelpItem)defaultMutableTreeNode.getUserObject();
        if (helpItem != null && helpItem.matches(uRL)) {
            return defaultMutableTreeNode;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findNode(uRL, defaultMutableTreeNode2);
            if (defaultMutableTreeNode3 == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    public URL getSelection() {
        return this.selection;
    }

    public void setSelection(URL uRL) {
        URL uRL2 = this.getSelection();
        this.selection = uRL;
        this.getHistory().setSelection(uRL);
        this.setTreeSelection(uRL);
        this.firePropertyChange(PROPERTYNAME_SELECTION, uRL2, uRL);
    }

    URL getBaseURL() {
        return this.helpSet.getBaseURL();
    }

    HelpHistory getHistory() {
        return this.history;
    }

    URL getHome() {
        return (URL)this.history.getHome();
    }

    TreeNode getRoot() {
        return this.helpSet.getRoot();
    }

    String getTitle() {
        return this.helpSet.getTitle();
    }

    Action getCloseAction() {
        return ActionManager.get((String)"com.jgoodies.help.close");
    }

    Action getPageSetupAction() {
        return ActionManager.get((String)"com.jgoodies.help.pageSetup");
    }

    Action getPrintAction() {
        return ActionManager.get((String)"com.jgoodies.help.print");
    }

    Action getGoBackAction() {
        return this.getHistory().getGoBackAction();
    }

    Action getGoNextAction() {
        return this.getHistory().getGoNextAction();
    }

    Action getGoHomeAction() {
        return this.getHistory().getGoHomeAction();
    }

    MouseListener getPopupListener() {
        if (this.popupAdapter == null) {
            this.popupAdapter = new PopupAdapter(true){

                protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                    return HelpModel.this.buildPopupMenu();
                }
            };
        }
        return this.popupAdapter;
    }

    private JPopupMenu buildPopupMenu() {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder(this.getTitle() + " Menu");
        popupMenuBuilder.add(new UIFMenuItem(this.getGoBackAction()));
        popupMenuBuilder.add(new UIFMenuItem(this.getGoNextAction()));
        popupMenuBuilder.add(new UIFMenuItem(this.getGoHomeAction()));
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(new UIFMenuItem(this.getPrintAction()));
        return popupMenuBuilder.getPopupMenu();
    }

    private final class NavigationTreeSelectionChangeHandler
    implements TreeSelectionListener {
        private NavigationTreeSelectionChangeHandler() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = HelpModel.this.navigationTreeSelectionModel.getSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            HelpItem helpItem = (HelpItem)defaultMutableTreeNode.getUserObject();
            URL uRL = helpItem.getURL();
            if (uRL != null) {
                HelpModel.this.setSelection(uRL);
            }
        }
    }

    private final class HistoryChangeHandler
    implements PropertyChangeListener {
        private HistoryChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HelpModel.this.setSelection((URL)HelpModel.this.history.getSelection());
        }
    }
}

