/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.help;

import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.help.HelpBroker;
import com.jgoodies.uifextras.help.HelpItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HelpSet {
    private static Logger logger = Logger.getLogger("HelpSet");
    private final URL baseURL;
    private final Map idsToURL;
    private String title;
    private URL home;
    private DefaultMutableTreeNode root;

    public HelpSet(ClassLoader classLoader, URL uRL) {
        this.baseURL = uRL;
        this.idsToURL = new HashMap();
        this.readHelpSet(uRL);
    }

    public static URL findHelpSet(ClassLoader classLoader, String string) {
        return ResourceUtils.getURL((String)string, (ClassLoader)classLoader);
    }

    public HelpBroker createHelpBroker() {
        return new HelpBroker(this);
    }

    URL getBaseURL() {
        return this.baseURL;
    }

    URL getHome() {
        return this.home;
    }

    TreeNode getRoot() {
        return this.root;
    }

    String getTitle() {
        return this.title;
    }

    URL idToURL(String string) {
        URL uRL = (URL)this.idsToURL.get(string);
        if (null == uRL) {
            logger.warning("HelpID " + string + " has no target URL.");
        }
        return uRL;
    }

    private DefaultMutableTreeNode createChapterNode(String string) {
        return new DefaultMutableTreeNode(HelpItem.createChapter(string));
    }

    private DefaultMutableTreeNode createTopicNode(String string, String string2) {
        return new DefaultMutableTreeNode(HelpItem.createTopic(string, this.idToURL(string2)));
    }

    private URL getFullPath(String string) {
        try {
            return new URL(this.baseURL, string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.warning("Can't form URL" + malformedURLException.getLocalizedMessage());
            return null;
        }
    }

    private void readHelpSet(URL uRL) {
        Document document = HelpSet.getDocument(uRL, "HelpSet");
        if (document != null) {
            this.parseHelpSet(document);
        }
    }

    private void parseHelpSet(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (string.equals("title")) {
                this.parseTitle(node);
                continue;
            }
            if (string.equals("maps")) {
                this.parseMaps(node);
                continue;
            }
            if (!string.equals("view")) continue;
            this.parseViews(node);
        }
    }

    private void parseTitle(Node node) {
        this.title = HelpSet.getTextValue(node);
    }

    private void parseMaps(Node node) {
        String string = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals("homeID")) {
                string = HelpSet.getTextValue(node2);
                continue;
            }
            if (!string2.equals("mapref")) continue;
            String string3 = HelpSet.getAttributeValue(node2, "location");
            this.readMap(string3);
        }
        this.home = this.idToURL(string);
    }

    private void parseViews(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals("data")) continue;
            this.readTOC(HelpSet.getTextValue(node2));
        }
    }

    private void readMap(String string) {
        URL uRL = this.getFullPath(string);
        Document document = HelpSet.getDocument(uRL, "HelpMap");
        if (document != null) {
            this.parseHelpMap(document);
        }
    }

    private void parseHelpMap(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (!string.equals("mapID")) continue;
            this.parseMapID(node);
        }
    }

    private void parseMapID(Node node) {
        String string;
        String string2 = HelpSet.getAttributeValue(node, "target");
        URL uRL = this.idsToURL.put(string2, this.getFullPath(string = HelpSet.getAttributeValue(node, "url")));
        if (uRL != null) {
            logger.severe("Duplicate entry in HelpSet map " + node.getOwnerDocument().getNamespaceURI() + ": target=" + string2 + " url=" + string);
        }
    }

    private void readTOC(String string) {
        URL uRL = this.getFullPath(string);
        Document document = HelpSet.getDocument(uRL, "HelpTOC");
        if (document != null) {
            this.parseHelpTOC(document);
        }
    }

    private void parseHelpTOC(Document document) {
        this.root = new DefaultMutableTreeNode(null);
        Element element = document.getDocumentElement();
        this.parseTOCItems(element, this.root);
    }

    private void parseTOCItems(Node node, DefaultMutableTreeNode defaultMutableTreeNode) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals("tocitem")) continue;
            String string2 = HelpSet.getAttributeValue(node2, "text");
            String string3 = HelpSet.getAttributeValue(node2, "image");
            String string4 = HelpSet.getAttributeValue(node2, "target");
            if ("chapter".equals(string3)) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.createChapterNode(string2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.parseTOCItems(node2, defaultMutableTreeNode2);
                continue;
            }
            defaultMutableTreeNode.add(this.createTopicNode(string2, string4));
        }
    }

    private static Document getDocument(URL uRL, String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new MyResolver());
            return documentBuilder.parse(uRL.toExternalForm());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.log(Level.WARNING, "Can't build " + string + " parser.", parserConfigurationException);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Can't open " + string + " from " + uRL, iOException);
        }
        catch (SAXException sAXException) {
            logger.log(Level.WARNING, "Can't parse " + string + " from " + uRL, sAXException);
        }
        return null;
    }

    private static String convertNodeValue(Node node) {
        if (node.getNodeValue() == null) {
            return null;
        }
        String string = node.getNodeValue().trim();
        int n = string.indexOf("\n");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static String getTextValue(Node node) {
        return node == null ? null : HelpSet.convertNodeValue(node.getFirstChild());
    }

    private static String getAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    private static final class MyResolver
    implements EntityResolver {
        private static final String HELPSET_1_0_DTD_PATH = "http://java.sun.com/products/javahelp/helpset_1_0.dtd";
        private static final String HELPSET_1_0_DTD_REPLACEMENT_PATH = "com/jgoodies/common/javahelp/dtd/helpset_1_0.dtd";
        private static final String MAP_1_0_DTD_PATH = "http://java.sun.com/products/javahelp/map_1_0.dtd";
        private static final String MAP_1_0_DTD_REPLACEMENT_PATH = "com/jgoodies/common/javahelp/dtd/map_1_0.dtd";
        private static final String TOC_1_0_DTD_PATH = "http://java.sun.com/products/javahelp/toc_1_0.dtd";
        private static final String TOC_1_0_DTD_REPLACEMENT_PATH = "com/jgoodies/common/javahelp/dtd/toc_1_0.dtd";

        private MyResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            String string3;
            if (string2.equals(HELPSET_1_0_DTD_PATH)) {
                string3 = HELPSET_1_0_DTD_REPLACEMENT_PATH;
            } else if (string2.equals(MAP_1_0_DTD_PATH)) {
                string3 = MAP_1_0_DTD_REPLACEMENT_PATH;
            } else if (string2.equals(TOC_1_0_DTD_PATH)) {
                string3 = TOC_1_0_DTD_REPLACEMENT_PATH;
            } else {
                return null;
            }
            InputStream inputStream = ResourceUtils.getInputStream((String)string3);
            return new InputSource(inputStream);
        }
    }
}

