/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.help;

import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.uif.AbstractFrame;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.builder.MenuBuilder;
import com.jgoodies.uif.builder.ToolBarBuilder;
import com.jgoodies.uif.component.UIFSplitPane;
import com.jgoodies.uif.util.SystemUtils;
import com.jgoodies.uifextras.help.HelpModel;
import com.jgoodies.uifextras.help.NavigationView;
import com.jgoodies.uifextras.help.PresentationView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

final class HelpViewer
extends AbstractFrame {
    private static final String DIVIDER_LOCATION_KEY = "help.frame.dividerLocation";
    private final HelpModel model;
    private NavigationView navigationView;
    private PresentationView presentationView;
    private JSplitPane splitPane;

    HelpViewer(HelpModel helpModel) {
        super(helpModel.getTitle());
        this.model = helpModel;
    }

    void setDisplayed(boolean bl) {
        if (bl) {
            this.show(this.model.getHome());
        } else {
            this.setVisible(false);
        }
    }

    void show(URL uRL) {
        if (!this.isVisible()) {
            this.open();
        } else {
            this.setState(0);
            this.setVisible(true);
        }
        this.model.setSelection(uRL);
    }

    public void build() {
        super.build();
        if (SystemUtils.IS_OS_MAC) {
            this.setJMenuBar(this.buildMenuBar());
        }
        this.setTitle(this.getTitle());
    }

    private void initComponents() {
        this.navigationView = new NavigationView(this.model);
        this.presentationView = new PresentationView(this.model);
    }

    protected JComponent buildContentPane() {
        this.initComponents();
        JPanel jPanel = new JPanel(new BorderLayout(0, 3));
        jPanel.add((Component)this.buildToolBar(), "North");
        jPanel.add((Component)this.buildNavigationPresentationPanel(), "Center");
        return jPanel;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        MenuBuilder menuBuilder = new MenuBuilder("File", 'F');
        menuBuilder.add(this.model.getCloseAction());
        menuBuilder.addSeparator();
        menuBuilder.add(this.model.getPageSetupAction());
        menuBuilder.add(this.model.getPrintAction());
        jMenuBar.add(menuBuilder.getMenu());
        menuBuilder = new MenuBuilder("History", 'H');
        menuBuilder.add(this.model.getGoBackAction());
        menuBuilder.add(this.model.getGoNextAction());
        menuBuilder.add(this.model.getGoHomeAction());
        jMenuBar.add(menuBuilder.getMenu());
        return jMenuBar;
    }

    private JToolBar buildToolBar() {
        ToolBarBuilder toolBarBuilder = new ToolBarBuilder(this.getTitle(), (Object)HeaderStyle.SINGLE);
        toolBarBuilder.getToolBar().putClientProperty("Plastic.borderStyle", "Separator");
        toolBarBuilder.addGap();
        toolBarBuilder.add(this.model.getGoBackAction());
        toolBarBuilder.addGap();
        toolBarBuilder.add(this.model.getGoNextAction());
        toolBarBuilder.addGap();
        toolBarBuilder.add(this.model.getGoHomeAction());
        toolBarBuilder.addGap();
        toolBarBuilder.add(this.model.getPrintAction());
        return toolBarBuilder.getToolBar();
    }

    private JComponent buildNavigationPresentationPanel() {
        this.splitPane = UIFSplitPane.createStrippedSplitPane((int)1, (Component)this.navigationView.getPanel(), (Component)this.presentationView.getPanel());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.splitPane, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        return jPanel;
    }

    public Dimension getWindowMinimumSize() {
        return new Dimension(200, 200);
    }

    public String getWindowID() {
        return "help";
    }

    protected void configureCloseOperation() {
        this.setDefaultCloseOperation(1);
    }

    protected void resizeHook(JComponent jComponent) {
    }

    protected void storeState() {
        if (this.splitPane == null) {
            return;
        }
        super.storeState();
        Application.getUserPreferences().putInt(DIVIDER_LOCATION_KEY, this.splitPane.getDividerLocation());
    }

    protected void restoreState() {
        super.restoreState();
        this.restoreDividerLocation(Application.getUserPreferences());
    }

    private void restoreDividerLocation(Preferences preferences) {
        int n = preferences.getInt(DIVIDER_LOCATION_KEY, -1);
        if (n == -1) {
            return;
        }
        if (n > this.getSize().width) {
            return;
        }
        this.splitPane.setDividerLocation(n);
    }
}

