/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.help;

import com.jgoodies.uif.AbstractView;
import com.jgoodies.uif.component.UIFTree;
import com.jgoodies.uif.util.TreeUtils;
import com.jgoodies.uifextras.help.HelpItem;
import com.jgoodies.uifextras.help.HelpModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;

final class NavigationView
extends AbstractView {
    private final HelpModel model;
    private JTree tree;

    NavigationView(HelpModel helpModel) {
        this.model = helpModel;
    }

    private void initComponents() {
        this.tree = new RefreshedTree(this.model.getNavigationTreeModel());
        this.tree.setSelectionModel(this.model.getNavigationTreeSelectionModel());
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new TreeCellRenderer());
        TreeUtils.expandTopLevel((JTree)this.tree);
    }

    private void initEventHandling() {
        this.tree.addMouseListener(this.model.getPopupListener());
        this.model.addPropertyChangeListener("selection", new SelectedURLChangeHandler());
    }

    protected JComponent buildPanel() {
        this.initComponents();
        this.initEventHandling();
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.putClientProperty("jgoodies.isEtched", Boolean.TRUE);
        ((JComponent)jScrollPane).updateUI();
        return jScrollPane;
    }

    private static final class RefreshedTree
    extends UIFTree {
        private RefreshedTree(TreeModel treeModel) {
            super(treeModel);
        }

        public void updateUI() {
            super.updateUI();
            this.setCellRenderer(new TreeCellRenderer());
        }
    }

    private static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, this.selected, bl2, bl3, n, bl4);
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            HelpItem helpItem = (HelpItem)defaultMutableTreeNode.getUserObject();
            if (null == helpItem) {
                return this;
            }
            this.setText(string);
            this.selected = helpItem.isChapter() ? false : bl;
            this.setForeground(this.selected ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
            this.setIcon(helpItem.getIcon(bl2));
            this.setFont(helpItem.isChapter() ? ((UIFTree)jTree).getBoldFont() : jTree.getFont());
            return this;
        }
    }

    private class SelectedURLChangeHandler
    implements PropertyChangeListener {
        private SelectedURLChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            NavigationView.this.tree.scrollPathToVisible(NavigationView.this.tree.getSelectionPath());
        }
    }
}

