/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.help;

import com.jgoodies.uif.AbstractView;
import com.jgoodies.uif.util.ScreenUtils;
import com.jgoodies.uifextras.help.HelpModel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

final class PresentationView
extends AbstractView {
    private static final int INITIAL_PRESENTATION_WIDTH = 420;
    private final HelpModel model;
    private JEditorPane editorPane;

    PresentationView(HelpModel helpModel) {
        this.model = helpModel;
    }

    private void initComponents() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.setMargin(new Insets(0, 10, 0, 5));
    }

    private void initEventHandling() {
        this.editorPane.addHyperlinkListener(new HyperlinkHandler());
        this.editorPane.addMouseListener(this.model.getPopupListener());
        this.model.addPropertyChangeListener("selection", new SelectedURLChangeHandler());
    }

    protected JComponent buildPanel() {
        this.initComponents();
        this.initEventHandling();
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        jScrollPane.putClientProperty("jgoodies.isEtched", Boolean.TRUE);
        ((JComponent)jScrollPane).updateUI();
        int n = 420;
        int n2 = ScreenUtils.has1024x768Screen() ? 600 : (ScreenUtils.has800x600Screen() ? 550 : 410);
        jScrollPane.setPreferredSize(new Dimension(n, n2));
        return jScrollPane;
    }

    private class SelectedURLChangeHandler
    implements PropertyChangeListener {
        private SelectedURLChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block2: {
                URL uRL = (URL)propertyChangeEvent.getNewValue();
                try {
                    PresentationView.this.editorPane.setPage(uRL);
                }
                catch (IOException iOException) {
                    if (uRL == null) break block2;
                    Logger.getLogger("help.PresentationPanel").warning("Can't show help URL: " + uRL);
                }
            }
        }
    }

    private class HyperlinkHandler
    implements HyperlinkListener {
        private HyperlinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ENTERED) {
                PresentationView.this.editorPane.setCursor(Cursor.getPredefinedCursor(12));
            } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                PresentationView.this.editorPane.setCursor(Cursor.getDefaultCursor());
            } else if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                PresentationView.this.model.setSelection(hyperlinkEvent.getURL());
            }
        }
    }
}

