/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.history;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.uif.action.ActionReader;
import com.jgoodies.uif.component.PopupButton;
import com.jgoodies.uif.component.ToolBarButton;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.history.HistoryList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class History
extends Model {
    public static final String PROPERTYNAME_HOME = "home";
    public static final String PROPERTYNAME_SELECTION = "selection";
    private static final int MAX_TOOLTIP_LENGTH = 60;
    private final Action goBackAction;
    private final Action goNextAction;
    private final Action goHomeAction;
    private final JPopupMenu backPopupMenu;
    private final JPopupMenu nextPopupMenu;
    private Object home;
    private int capacity;
    private HistoryList list;

    public History(int n) {
        this.capacity = n;
        this.goBackAction = new NavigationAction("back");
        this.goNextAction = new NavigationAction("next");
        this.goHomeAction = new NavigationAction(PROPERTYNAME_HOME);
        this.backPopupMenu = new JPopupMenu();
        this.backPopupMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
        this.nextPopupMenu = new JPopupMenu();
        this.nextPopupMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
        this.reset();
    }

    protected String createToolTip(Object object) {
        return History.centerClippedString(object.toString(), 60);
    }

    private static String centerClippedString(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = n / 2;
        int n4 = n - n3 - 3;
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n2 - n4, n2 - 1);
        return string2 + "\u2026" + string3;
    }

    public Action getGoBackAction() {
        return this.goBackAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getGoNextAction() {
        return this.goNextAction;
    }

    public Object getHome() {
        return this.home;
    }

    public void setHome(Object object) {
        Object object2 = this.getHome();
        this.home = object;
        this.firePropertyChange(PROPERTYNAME_HOME, object2, object);
    }

    public PopupButton createGoBackButton() {
        return new PopupButton((JButton)new ToolBarButton(this.getGoBackAction()), this.backPopupMenu);
    }

    public PopupButton createGoNextButton() {
        return new PopupButton((JButton)new ToolBarButton(this.getGoNextAction()), this.nextPopupMenu);
    }

    private String getBackText() {
        Object object = this.list.getPrevious();
        if (null == object) {
            return this.getString("history.back.text", "Back");
        }
        return MessageFormat.format(this.getString("history.backTo.text", "Back to {0}"), this.createToolTip(object));
    }

    private String getNextText() {
        Object object = this.list.getNext();
        if (null == object) {
            return this.getString("history.next.text", "Next");
        }
        return MessageFormat.format(this.getString("history.nextTo.text", "Next to {0}"), this.createToolTip(object));
    }

    public void reset() {
        this.list = new HistoryList(this.capacity);
        this.goBackAction.setEnabled(false);
        this.goNextAction.setEnabled(false);
        this.goHomeAction.setEnabled(false);
    }

    public Object getSelection() {
        return this.list.getLastAdded();
    }

    public void setSelection(Object object) {
        Object object2 = this.getSelection();
        if (this.equals(object2, object)) {
            return;
        }
        this.setSelection0(object);
    }

    private void setSelection0(Object object) {
        if (null == object) {
            return;
        }
        this.list.add(object);
        this.updateMenu(this.backPopupMenu, this.list.getBackIterator(), true);
        this.updateMenu(this.nextPopupMenu, this.list.getNextIterator(), false);
        this.updateActions();
        this.firePropertyChange(PROPERTYNAME_SELECTION, null, object);
    }

    private void updateActions() {
        Object object = this.getSelection();
        Object object2 = this.list.getPrevious();
        Object object3 = this.list.getNext();
        String string = this.getBackText();
        String string2 = this.getNextText();
        this.goBackAction.putValue("ShortDescription", string);
        this.goBackAction.putValue("Name", string);
        this.goNextAction.putValue("ShortDescription", string2);
        this.goNextAction.putValue("Name", string2);
        this.goBackAction.setEnabled(object2 != null);
        this.goNextAction.setEnabled(object3 != null);
        this.goHomeAction.setEnabled(!this.home.equals(object));
    }

    private void updateMenu(JPopupMenu jPopupMenu, Iterator iterator, final boolean bl) {
        jPopupMenu.removeAll();
        int n = 1;
        while (iterator.hasNext()) {
            final int n2 = n++;
            String string = this.createToolTip(iterator.next());
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.putClientProperty("noIcon", Boolean.TRUE);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl) {
                        History.this.list.goBack(n2);
                    } else {
                        History.this.list.goNext(n2);
                    }
                    History.this.updateState();
                }
            });
            jPopupMenu.add(jMenuItem);
        }
    }

    private void updateState() {
        this.updateMenu(this.backPopupMenu, this.list.getBackIterator(), true);
        this.updateMenu(this.nextPopupMenu, this.list.getNextIterator(), false);
        this.updateActions();
        this.firePropertyChange(PROPERTYNAME_SELECTION, null, this.getSelection());
    }

    private String getString(String string, String string2) {
        return ActionReader.getString((ResourceBundle)ResourceUtils.getBundle(), (String)string, (String)string2);
    }

    private final class NavigationAction
    extends AbstractAction {
        private static final String BACK = "back";
        private static final String NEXT = "next";
        private static final String HOME = "home";
        private final String id;

        private NavigationAction(String string) {
            this.id = string;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (this.id.equals(BACK)) {
                object = History.this.list.getAndGoPrevious();
            } else if (this.id.equals(NEXT)) {
                object = History.this.list.getAndGoNext();
            } else if (this.id.equals("home")) {
                object = History.this.home;
            } else {
                Logger.getLogger("History.NavigationAction").warning("Unknown id: " + this.id);
                return;
            }
            History.this.setSelection0(object);
        }
    }
}

