/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class HistoryList {
    private final int limit;
    private final List list;
    private int indexOfNextAdd;

    public HistoryList(int n) {
        this.limit = n;
        this.list = new ArrayList(n);
        this.indexOfNextAdd = 0;
    }

    public boolean add(Object object) {
        if (object.equals(this.getLastAdded())) {
            return false;
        }
        for (int i = this.list.size() - 1; i > 0 && i >= this.indexOfNextAdd; --i) {
            this.list.remove(i);
        }
        this.list.add(this.indexOfNextAdd, object);
        if (this.list.size() > this.limit) {
            this.list.remove(0);
        } else {
            ++this.indexOfNextAdd;
        }
        return true;
    }

    public Object getAndGoPrevious() {
        return this.hasPrevious() ? this.list.get(--this.indexOfNextAdd - 1) : null;
    }

    public Object getAndGoNext() {
        return this.hasNext() ? this.list.get(this.indexOfNextAdd++) : null;
    }

    public Iterator getBackIterator() {
        List list = this.subListNoDuplicates(0, this.indexOfNextAdd - 1);
        Collections.reverse(list);
        return list.iterator();
    }

    public Iterator getNextIterator() {
        return this.subListNoDuplicates(this.indexOfNextAdd, this.list.size()).iterator();
    }

    public Object getLastAdded() {
        return this.indexOfNextAdd > 0 ? this.list.get(this.indexOfNextAdd - 1) : null;
    }

    public Object getPrevious() {
        return this.hasPrevious() ? this.list.get(this.indexOfNextAdd - 2) : null;
    }

    public Object getNext() {
        return this.hasNext() ? this.list.get(this.indexOfNextAdd) : null;
    }

    public void goBack(int n) {
        this.indexOfNextAdd = Math.max(0, this.indexOfNextAdd - n);
    }

    public void goNext(int n) {
        this.indexOfNextAdd = Math.min(this.indexOfNextAdd + n, this.list.size());
    }

    public boolean hasPrevious() {
        return this.indexOfNextAdd > 1;
    }

    public boolean hasNext() {
        return this.indexOfNextAdd < this.list.size();
    }

    private List subListNoDuplicates(int n, int n2) {
        Object object = this.getLastAdded();
        ArrayList arrayList = new ArrayList();
        for (int i = n; i < n2; ++i) {
            Object e = this.list.get(i);
            if (e == object) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public String toString() {
        return "(Limit: " + this.limit + "; indexOfNextAdd: " + this.indexOfNextAdd + ")" + this.list.toString();
    }
}

