/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.laf;

import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.laf.ExtUIManager;
import com.jgoodies.uif.laf.LookConfiguration;
import com.jgoodies.uif.laf.LookConfigurations;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class LafChoiceModel
extends Model {
    public static final String PROPERTYNAME_SELECTED_CONFIGURATION = "selectedConfiguration";
    private final ValueModel triggerChannel;
    private final BeanAdapter configurationsAdapter;
    private final BeanAdapter selectedConfigurationAdapter;
    private final SelectionInList configurationSelection;
    private final SelectionInList themeSelection;
    private PropertyChangeListener themeChangeHandler;

    public LafChoiceModel(ValueModel valueModel) {
        this.triggerChannel = valueModel;
        this.configurationsAdapter = new BeanAdapter((Object)ExtUIManager.getLookConfigurations(), true);
        AbstractValueModel abstractValueModel = this.configurationsAdapter.getValueModel("configurations");
        AbstractValueModel abstractValueModel2 = this.configurationsAdapter.getValueModel("defaultConfiguration");
        this.configurationSelection = new SelectionInList((ValueModel)abstractValueModel, (ValueModel)abstractValueModel2);
        this.selectedConfigurationAdapter = new BeanAdapter((ValueModel)abstractValueModel2, true);
        AbstractValueModel abstractValueModel3 = this.selectedConfigurationAdapter.getValueModel("themes");
        AbstractValueModel abstractValueModel4 = this.selectedConfigurationAdapter.getValueModel("theme");
        this.themeSelection = new SelectionInList((ValueModel)abstractValueModel3, (ValueModel)abstractValueModel4);
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.getConfigurationSelection().addPropertyChangeListener("selection", (PropertyChangeListener)new ConfigurationChangeHandler());
        this.themeChangeHandler = new ThemeChangeHandler();
        this.getThemeSelection().addPropertyChangeListener("selection", this.themeChangeHandler);
        this.triggerChannel.addValueChangeListener((PropertyChangeListener)new TriggerChangeHandler());
    }

    public SelectionInList getConfigurationSelection() {
        return this.configurationSelection;
    }

    public SelectionInList getThemeSelection() {
        return this.themeSelection;
    }

    public LookConfiguration getSelectedConfiguration() {
        return (LookConfiguration)this.configurationSelection.getSelection();
    }

    private void fireSelectedConfigurationChanged(LookConfiguration lookConfiguration) {
        this.firePropertyChange(PROPERTYNAME_SELECTED_CONFIGURATION, null, lookConfiguration);
    }

    private void commitLookConfigurations() {
        LookConfigurations lookConfigurations = (LookConfigurations)this.configurationsAdapter.getBean();
        ExtUIManager.setLookConfigurations((LookConfigurations)lookConfigurations);
        this.configurationsAdapter.setBean((Object)ExtUIManager.getLookConfigurations());
    }

    private void flushLookConfigurations() {
        this.configurationsAdapter.setBean((Object)ExtUIManager.getLookConfigurations());
    }

    private class TriggerChangeHandler
    implements PropertyChangeListener {
        private TriggerChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                LafChoiceModel.this.commitLookConfigurations();
            } else if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                LafChoiceModel.this.flushLookConfigurations();
            }
        }
    }

    private class ThemeChangeHandler
    implements PropertyChangeListener {
        private ThemeChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LafChoiceModel.this.fireSelectedConfigurationChanged(LafChoiceModel.this.getSelectedConfiguration());
        }
    }

    private class ConfigurationChangeHandler
    implements PropertyChangeListener {
        private ConfigurationChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LookConfiguration lookConfiguration = (LookConfiguration)propertyChangeEvent.getNewValue();
            LafChoiceModel.this.themeSelection.removePropertyChangeListener("selection", LafChoiceModel.this.themeChangeHandler);
            LafChoiceModel.this.selectedConfigurationAdapter.setBean((Object)lookConfiguration);
            LafChoiceModel.this.themeSelection.addPropertyChangeListener("selection", LafChoiceModel.this.themeChangeHandler);
            LafChoiceModel.this.fireSelectedConfigurationChanged(lookConfiguration);
        }
    }
}

