/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.laf;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.uif.AbstractView;
import com.jgoodies.uif.laf.LookConfiguration;
import com.jgoodies.uifextras.laf.LafChoiceModel;
import com.jgoodies.uifextras.laf.LafChoicePreviewPanel;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.metal.MetalTheme;

public class LafChoicePanelBuilder
extends AbstractView {
    private final LafChoiceModel lafChoiceModel;
    private JList lafList;
    private JList themesList;
    private LafChoicePreviewPanel previewPanel;

    public LafChoicePanelBuilder(LafChoiceModel lafChoiceModel) {
        this.lafChoiceModel = lafChoiceModel;
    }

    private void initComponents() {
        this.lafList = BasicComponentFactory.createList((SelectionInList)this.lafChoiceModel.getConfigurationSelection(), (ListCellRenderer)new LookConfigurationListCellRenderer());
        this.themesList = BasicComponentFactory.createList((SelectionInList)this.lafChoiceModel.getThemeSelection(), (ListCellRenderer)new ThemeListCellRenderer());
        this.previewPanel = this.createPreviewPanel();
    }

    protected LafChoicePreviewPanel createPreviewPanel() {
        return new LafChoicePreviewPanel();
    }

    protected FormLayout createPanelLayout() {
        FormLayout formLayout = new FormLayout("fill:default:grow, 4dlu, fill:default:grow", "pref, 1dlu, fill:100dlu, 9dlu, pref, 1dlu, pref");
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3}});
        formLayout.setRowGroups((int[][])new int[][]{{3, 7}});
        return formLayout;
    }

    private void initEventHandling() {
        this.lafChoiceModel.addPropertyChangeListener("selectedConfiguration", new LookConfigurationChangeHandler());
    }

    public JComponent build() {
        return this.buildPanel();
    }

    protected JComponent buildPanel() {
        this.initComponents();
        this.initEventHandling();
        FormLayout formLayout = this.createPanelLayout();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addTitle("Look && Feel", cellConstraints.xy(1, 1));
        panelBuilder.addTitle("Theme", cellConstraints.xy(3, 1));
        panelBuilder.add((Component)new JScrollPane(this.lafList), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)new JScrollPane(this.themesList), cellConstraints.xy(3, 3));
        panelBuilder.addTitle("Preview", cellConstraints.xyw(1, 5, 3));
        panelBuilder.add((Component)((Object)this.previewPanel), cellConstraints.xyw(1, 7, 3));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.addComponentListener(new SelectionsVisibleHandler());
        return jPanel;
    }

    private static class ThemeListCellRenderer
    extends DefaultListCellRenderer {
        private ThemeListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, object instanceof MetalTheme ? ((MetalTheme)object).getName() : object, n, bl, bl2);
        }
    }

    private static class LookConfigurationListCellRenderer
    extends DefaultListCellRenderer {
        private LookConfigurationListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, ((LookConfiguration)object).getLookAndFeel().getName(), n, bl, bl2);
        }
    }

    private class SelectionsVisibleHandler
    extends ComponentAdapter {
        private SelectionsVisibleHandler() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            LafChoicePanelBuilder.this.lafList.ensureIndexIsVisible(LafChoicePanelBuilder.this.lafList.getSelectedIndex());
            LafChoicePanelBuilder.this.themesList.ensureIndexIsVisible(LafChoicePanelBuilder.this.themesList.getSelectedIndex());
        }
    }

    private class LookConfigurationChangeHandler
    implements PropertyChangeListener {
        private LookConfigurationChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LookConfiguration lookConfiguration = (LookConfiguration)propertyChangeEvent.getNewValue();
            boolean bl = !lookConfiguration.getThemes().isEmpty();
            LafChoicePanelBuilder.this.themesList.ensureIndexIsVisible(LafChoicePanelBuilder.this.themesList.getSelectedIndex());
            LafChoicePanelBuilder.this.themesList.setEnabled(bl);
            LafChoicePanelBuilder.this.previewPanel.update(lookConfiguration.getLookAndFeel(), (PlasticTheme)lookConfiguration.getTheme());
        }
    }
}

