/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.laf;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.uif.component.UIFTree;
import com.jgoodies.uif.panel.CardPanel;
import com.jgoodies.uif.util.ComponentTreeUtils;
import com.jgoodies.uifextras.util.ExtTable;
import com.jgoodies.uifextras.util.ThinBevelBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class LafChoicePreviewPanel
extends CardPanel {
    protected static final Dimension PREFERRED_SIZE = new Dimension(300, 170);
    protected static final String PREVIEW_CARD = "preview";
    protected static final String FAKE_CARD = "fake";
    protected final JPanel delegate = this.buildSampleWidgetsPanel();
    protected Image buffer;

    public LafChoicePreviewPanel() {
        this.add(this.delegate, PREVIEW_CARD);
        this.add(new JLabel("Hallo"), FAKE_CARD);
    }

    void update(LookAndFeel lookAndFeel, PlasticTheme plasticTheme) {
        try {
            LookAndFeel lookAndFeel2 = UIManager.getLookAndFeel();
            PlasticTheme plasticTheme2 = null;
            if (lookAndFeel instanceof PlasticLookAndFeel) {
                plasticTheme2 = PlasticLookAndFeel.getMyCurrentTheme();
                if (plasticTheme != null) {
                    PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)plasticTheme);
                }
            }
            UIManager.setLookAndFeel(lookAndFeel);
            this.updateAndValidate();
            if (lookAndFeel instanceof PlasticLookAndFeel) {
                PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)plasticTheme2);
            }
            UIManager.setLookAndFeel(lookAndFeel2);
            this.updateComponentTree();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
    }

    protected void updateComponentTree() {
        ComponentTreeUtils.updateComponentTreeUI((Component)this.delegate);
    }

    protected synchronized void updateAndValidate() {
        this.updateComponentTree();
        this.ensureHasBuffer();
        this.updateBuffer();
    }

    public void paint(Graphics graphics) {
        this.ensureHasBuffer();
        graphics.drawImage(this.buffer, 0, 0, null);
    }

    protected synchronized void ensureHasBuffer() {
        if (this.buffer != null) {
            return;
        }
        this.buffer = this.createImage(this.getWidth(), this.getHeight());
        this.updateBuffer();
    }

    protected void updateBuffer() {
        this.validate();
        this.showCard(PREVIEW_CARD);
        int n = this.buffer.getWidth(null);
        int n2 = this.buffer.getHeight(null);
        Graphics graphics = this.buffer.getGraphics();
        graphics.setClip(0, 0, n, n2);
        super.paint(graphics);
        graphics.dispose();
        this.showCard(FAKE_CARD);
    }

    protected JPanel buildSampleWidgetsPanel() {
        JTextField jTextField = new JTextField("Margin, Baseline, Space");
        FormLayout formLayout = new FormLayout("0:grow, 7dlu, 0:grow, 7dlu, 0:grow", "fill:min:grow, 7dlu, pref");
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3, 5}});
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(new ThinBevelBorder(1), Borders.DIALOG_BORDER));
        jPanel.setPreferredSize(PREFERRED_SIZE);
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)this.buildTree(), cellConstraints.xy(1, 1));
        jPanel.add((Component)this.buildTable(), cellConstraints.xy(3, 1));
        jPanel.add((Component)this.buildTabbedPane(), cellConstraints.xy(5, 1));
        jPanel.add((Component)jTextField, cellConstraints.xy(1, 3));
        jPanel.add((Component)this.buildComboBoxes(), cellConstraints.xy(3, 3));
        jPanel.add((Component)this.buildButtons(), cellConstraints.xy(5, 3));
        return jPanel;
    }

    protected JComponent buildTree() {
        UIFTree uIFTree = new UIFTree(this.createPreviewTreeModel());
        uIFTree.expandRow(2);
        JScrollPane jScrollPane = new JScrollPane((Component)uIFTree);
        return jScrollPane;
    }

    protected JComponent buildTable() {
        ExtTable extTable = new ExtTable(new String[][]{{"Ayler", "Greenwich Village"}, {"Coltrane", "Ascension"}, {"Davis", "In a Silent Way"}, {"Sanders", "Karma"}, {"Shorter", "Juju"}}, new String[]{"Artist", "Title      "});
        extTable.setAutoResizeMode(0);
        extTable.getColumnModel().getColumn(0).setPreferredWidth(55);
        extTable.getColumnModel().getColumn(1).setPreferredWidth(110);
        extTable.setRowSelectionInterval(2, 2);
        JScrollPane jScrollPane = new JScrollPane(extTable, 21, 31);
        return jScrollPane;
    }

    protected JComponent buildTabbedPane() {
        JRadioButton jRadioButton = new JRadioButton("Radio", true);
        jRadioButton.setOpaque(false);
        JCheckBox jCheckBox = new JCheckBox("Check", true);
        jCheckBox.setOpaque(false);
        JLabel jLabel = new JLabel("Label");
        JProgressBar jProgressBar = new JProgressBar(1, 0, 100){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 50);
            }
        };
        jProgressBar.setValue(50);
        JSlider jSlider = new JSlider(1){

            public Dimension getPreferredSize() {
                Dimension dimension = new Dimension(super.getPreferredSize().width, 50);
                return dimension;
            }
        };
        jSlider.setOpaque(false);
        FormLayout formLayout = new FormLayout("pref:grow, 4dlu, pref, 4dlu, min", "pref, pref, 2dlu, top:pref:grow");
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        jPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)jRadioButton, cellConstraints.xy(1, 1));
        jPanel.add((Component)jCheckBox, cellConstraints.xy(1, 2));
        jPanel.add((Component)jLabel, cellConstraints.xy(1, 4));
        jPanel.add((Component)jProgressBar, cellConstraints.xywh(3, 1, 1, 4));
        jPanel.add((Component)jSlider, cellConstraints.xywh(5, 1, 1, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Tab1", jPanel);
        jTabbedPane.add("Tab2", new JLabel("Hidden"));
        return jTabbedPane;
    }

    protected JComponent buildComboBoxes() {
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"Margin", "Two", "Three"});
        jComboBox.setEditable(true);
        JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{"Height", "Three", "Four"});
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        jPanel.add(jComboBox);
        jPanel.add(jComboBox2);
        return jPanel;
    }

    protected JComponent buildButtons() {
        JButton jButton = new JButton("Wide");
        jButton.setMnemonic('W');
        JButton jButton2 = new JButton("Narrow");
        jButton2.putClientProperty("jgoodies.isNarrow", Boolean.TRUE);
        JPanel jPanel = new JPanel(new BorderLayout(6, 0));
        jPanel.add((Component)jButton, "Center");
        jPanel.add((Component)jButton2, "East");
        return jPanel;
    }

    protected TreeModel createPreviewTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Musicians");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Piano");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Alexander von Schlippenbach"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("McCoy Tyner"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Sun Ra"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Saxophon");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Albert Ayler"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Archie Shepp"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Charlie Parker"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("John Coltrane"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Ornette Coleman"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Sonny Rollins"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }
}

