/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.panel;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.component.ToolBarButton;
import com.jgoodies.uif.util.CompoundIcon;
import com.jgoodies.uif.util.NullIcon;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.util.ActionLabel;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ActionPanel
extends JPanel {
    public static final Color DEFAULT_ENABLED_COLOR = Color.DARK_GRAY.brighter();
    public static final Color DEFAULT_DISABLED_COLOR = Color.LIGHT_GRAY.darker();
    private final Icon defaultIcon;
    private final boolean forceDefaultIcon;
    private boolean showingHelpTexts = true;

    public ActionPanel() {
        this((Icon)null, false);
    }

    public ActionPanel(Icon icon, boolean bl) {
        super((LayoutManager)new FormLayout("fill:pref:grow", ""));
        this.forceDefaultIcon = bl;
        this.setOpaque(false);
        if (icon != null) {
            this.defaultIcon = icon;
        } else {
            ImageIcon imageIcon = ResourceUtils.getIcon((String)"actionPanel.default.icon");
            this.defaultIcon = new CompoundIcon((Icon)imageIcon, (Icon)new NullIcon(new Dimension(14, 10)));
        }
    }

    public boolean isShowingHelpTexts() {
        return this.showingHelpTexts;
    }

    public void setShowingHelpTexts(boolean bl) {
        this.showingHelpTexts = bl;
    }

    public JComponent add(Action action) {
        return this.add(action, null);
    }

    public JComponent add(Action action, Icon icon) {
        if (!action.isEnabled()) {
            return null;
        }
        JComponent jComponent = this.createActionComponent(action, icon);
        this.addAction(jComponent);
        return jComponent;
    }

    private void addAction(JComponent jComponent) {
        FormLayout formLayout = (FormLayout)this.getLayout();
        formLayout.appendRow(FormFactory.UNRELATED_GAP_ROWSPEC);
        formLayout.appendRow(FormFactory.PREF_ROWSPEC);
        this.add((Component)jComponent, new CellConstraints(1, formLayout.getRowCount()));
    }

    public void addSeparator() {
        FormLayout formLayout = (FormLayout)this.getLayout();
        formLayout.appendRow(FormFactory.UNRELATED_GAP_ROWSPEC);
    }

    private JComponent createActionComponent(Action action, Icon icon) {
        String string = (String)action.getValue("ShortDescription");
        String string2 = (String)action.getValue("LongDescription");
        ToolBarButton toolBarButton = new ToolBarButton(action);
        toolBarButton.setContentAreaFilled(false);
        toolBarButton.setIcon(icon != null ? icon : this.getIconFor(action));
        if (this.forceDefaultIcon) {
            toolBarButton.setRolloverIcon(null);
        }
        toolBarButton.setBorder(Borders.EMPTY_BORDER);
        FormLayout formLayout = new FormLayout("pref, 3dlu, left:pref", "pref, 1dlu, pref");
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        jPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)toolBarButton, cellConstraints.xy(1, 1));
        jPanel.add((Component)this.createActionLabel(string, action), cellConstraints.xy(3, 1));
        if (this.isShowingHelpTexts()) {
            cellConstraints.insets = new Insets(0, 1, 0, 0);
            jPanel.add((Component)UIFactory.createPlainLabel(string2, Color.BLACK), cellConstraints.xy(3, 3));
        }
        return jPanel;
    }

    private JLabel createActionLabel(String string, Action action) {
        ActionLabel actionLabel = new ActionLabel(action);
        actionLabel.setText(string);
        actionLabel.setForeground(action.isEnabled() ? DEFAULT_ENABLED_COLOR : DEFAULT_DISABLED_COLOR);
        actionLabel.setIcon(null);
        actionLabel.setFontStyle(1);
        actionLabel.setFontSizeDelta(6);
        actionLabel.setDisplayedMnemonic(-1);
        actionLabel.setLinkColor(Color.BLACK);
        actionLabel.setToolTipText(null);
        actionLabel.setAntiAliased(true);
        return actionLabel;
    }

    private Icon getIconFor(Action action) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        return this.forceDefaultIcon || null == icon ? this.defaultIcon : icon;
    }
}

