/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.panel;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GradientBackgroundPanel
extends JPanel {
    private static final Color TRANSPARENT_WHITE = new Color(255, 255, 255, 0);
    private boolean horizontal;

    public GradientBackgroundPanel() {
        this(true);
    }

    public GradientBackgroundPanel(boolean bl) {
        super(new BorderLayout());
        this.horizontal = bl;
    }

    public GradientBackgroundPanel(JComponent jComponent, boolean bl) {
        this(bl);
        jComponent.setOpaque(false);
        this.add(jComponent);
    }

    protected void paintComponent(Graphics graphics) {
        GradientBackgroundPanel.paintBackground(graphics, this, this.getWidth(), this.getHeight(), this.isHorizontal());
    }

    protected boolean isHorizontal() {
        return this.horizontal;
    }

    public static void paintBackground(Graphics graphics, Component component, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            n6 = rectangle.x;
            n5 = rectangle.y;
            n4 = rectangle.width;
            n3 = rectangle.height;
        } else {
            n6 = 0;
            n5 = 0;
            n4 = n;
            n3 = n2;
        }
        if (!GradientBackgroundPanel.isTrueColor(component)) {
            GradientBackgroundPanel.paintWhiteBackground(graphics2D, n6, n5, n4, n3);
        } else if (bl) {
            GradientBackgroundPanel.paintHorizontalGradient(graphics2D, n6, n5, n4, n3, n, n2);
        } else {
            GradientBackgroundPanel.paintDiagonalGradient(graphics2D, n6, n5, n4, n3, n, n2);
        }
    }

    private static void paintWhiteBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(n, n2, n3, n4);
    }

    private static void paintHorizontalGradient(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = GradientBackgroundPanel.getHorizontalGradientColor(UIManager.getColor("control"));
        graphics2D.setPaint(new GradientPaint(100.0f, n6, Color.WHITE, n5, n6, color));
        graphics2D.fillRect(n, n2, n3, n4);
    }

    private static void paintDiagonalGradient(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = GradientBackgroundPanel.getDiagonalGradientColor(UIManager.getColor("control"));
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(new GradientPaint(n5 - 50, n6 - 300, TRANSPARENT_WHITE, n5, n6, color));
        graphics2D.fillRect(n, n2, n3, n4);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics2D.setPaint(new GradientPaint(n5 - 300, n6 - 200, TRANSPARENT_WHITE, n5, n6, color));
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setComposite(composite);
    }

    private static Color getHorizontalGradientColor(Color color) {
        float f = 0.7f;
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f2 = fArray[2];
        if (f2 > f) {
            return color;
        }
        float f3 = fArray[0];
        float f4 = fArray[1];
        return Color.getHSBColor(f3, f4, Math.max(f, f2));
    }

    private static Color getDiagonalGradientColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        if (f3 > 0.8f) {
            f3 *= 0.85f;
        }
        f3 = Math.max(0.6f, Math.min(0.8f, f3));
        return Color.getHSBColor(f, f2, f3);
    }

    private static boolean isTrueColor(Component component) {
        return component.getToolkit().getColorModel().getPixelSize() >= 24;
    }
}

