/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uifextras.panel.GradientBackgroundPanel;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class HeaderPanel
extends JPanel {
    public static final String PROPERTYNAME_TITLE = "title";
    public static final String PROPERTYNAME_DESCRIPTION = "description";
    public static final String PROPERTYNAME_ICON = "icon";
    public static final ConstantSize DEFAULT_MINIMUM_WIDTH = Sizes.dluX((int)200);
    public static final ConstantSize DEFAULT_MINIMUM_HEIGHT = Sizes.pixel((int)70);
    private final ConstantSize minimumWidth;
    private final ConstantSize minimumHeight;
    private JLabel titleLabel;
    private JLabel iconLabel;
    private JTextComponent descriptionArea;
    private JComponent backgroundComponent;

    public HeaderPanel(String string, String string2) {
        this(string, string2, null);
    }

    public HeaderPanel(String string, String string2, Icon icon) {
        this(string, string2, icon, DEFAULT_MINIMUM_WIDTH, DEFAULT_MINIMUM_HEIGHT);
    }

    public HeaderPanel(String string, String string2, Icon icon, ConstantSize constantSize, ConstantSize constantSize2) {
        this(string, string2, icon, new GradientBackgroundPanel(true), constantSize, constantSize2);
    }

    public HeaderPanel(String string, String string2, Icon icon, JComponent jComponent, ConstantSize constantSize, ConstantSize constantSize2) {
        super(true);
        this.minimumWidth = constantSize;
        this.minimumHeight = constantSize2;
        this.initComponents();
        this.setTitle(string);
        this.setDescription(string2);
        this.setIcon(icon);
        this.backgroundComponent = jComponent;
        this.build();
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String string) {
        String string2 = this.getTitle();
        this.titleLabel.setText(string);
        this.firePropertyChange(PROPERTYNAME_TITLE, string2, string);
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    public void setDescription(String string) {
        String string2 = this.getDescription();
        this.descriptionArea.setText(string);
        this.firePropertyChange(PROPERTYNAME_DESCRIPTION, string2, string);
    }

    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.getIcon();
        Icon icon3 = this.getScaledIcon(icon);
        this.iconLabel.setIcon(icon3);
        this.firePropertyChange(PROPERTYNAME_ICON, icon2, icon3);
    }

    private Icon getScaledIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon.getIconWidth() > 20 || !(icon instanceof ImageIcon)) {
            return icon;
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = imageIcon.getImage();
        int n = 2 * icon.getIconWidth();
        int n2 = 2 * icon.getIconHeight();
        image = image.getScaledInstance(n, n2, 4);
        return new ImageIcon(image);
    }

    private void initComponents() {
        this.titleLabel = this.createTitleLabel();
        this.descriptionArea = this.createDescriptionArea();
        this.iconLabel = new JLabel();
    }

    protected JLabel createTitleLabel() {
        return UIFactory.createBoldLabel("", 0, Color.BLACK);
    }

    protected JTextComponent createDescriptionArea() {
        JTextArea jTextArea = UIFactory.createWrappedMultilineLabel("");
        jTextArea.setLineWrap(false);
        jTextArea.setForeground(Color.BLACK);
        jTextArea.setRows(2);
        return jTextArea;
    }

    protected JComponent createDefaultBackgroundComponent() {
        return new GradientBackgroundPanel(true);
    }

    protected void build() {
        ColumnSpec columnSpec = new ColumnSpec(ColumnSpec.FILL, Sizes.bounded((Size)Sizes.PREFERRED, (Size)this.minimumWidth, null), 1.0);
        RowSpec rowSpec = new RowSpec(RowSpec.FILL, Sizes.bounded((Size)Sizes.PREFERRED, (Size)this.minimumHeight, null), 0.0);
        RowSpec rowSpec2 = new RowSpec((Size)Sizes.PREFERRED);
        FormLayout formLayout = new FormLayout(new ColumnSpec[]{columnSpec}, new RowSpec[]{rowSpec, rowSpec2});
        this.setLayout((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.add((Component)this.buildCenterComponent(), cellConstraints.xy(1, 1));
        this.add((Component)this.buildBottomComponent(), cellConstraints.xy(1, 2));
        this.add((Component)this.backgroundComponent, cellConstraints.xywh(1, 1, 1, 2));
    }

    protected JComponent buildCenterComponent() {
        FormLayout formLayout = new FormLayout("7dlu, 9dlu, 175dlu:grow, 7dlu, pref, 4dlu", "4dlu, 3dlu, pref, 2dlu, pref, 0:grow, 3dlu, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.titleLabel, cellConstraints.xyw(2, 3, 2));
        panelBuilder.add((Component)this.descriptionArea, cellConstraints.xywh(3, 5, 1, 2));
        panelBuilder.add((Component)this.iconLabel, cellConstraints.xywh(5, 2, 1, 6));
        return panelBuilder.getPanel();
    }

    protected JComponent buildBottomComponent() {
        return new JSeparator();
    }
}

