/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.panel;

import com.jgoodies.uif.util.CompoundIcon;
import com.jgoodies.uif.util.NullIcon;
import com.jgoodies.uif.util.ResourceUtils;
import com.jgoodies.uifextras.util.ActionLabel;
import com.jgoodies.uifextras.util.GradientSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class ItemPanel
extends JPanel {
    private final Icon defaultIcon;
    private final boolean forceDefaultIcon;

    public ItemPanel() {
        this(null, false, Color.BLACK);
    }

    public ItemPanel(Icon icon) {
        this(icon, false, Color.BLACK);
    }

    public ItemPanel(Icon icon, boolean bl, Color color) {
        super(new GridBagLayout());
        ImageIcon imageIcon;
        this.forceDefaultIcon = bl;
        this.setOpaque(false);
        this.defaultIcon = icon != null ? icon : ((imageIcon = ResourceUtils.getIcon((String)"actionPanel.default.icon")).getIconWidth() < 16 ? new CompoundIcon((Icon)imageIcon, (Icon)new NullIcon(new Dimension(16, 10))) : imageIcon);
    }

    public JComponent add(Action action) {
        JComponent jComponent = this.createActionComponent(action);
        this.addAction(jComponent);
        return jComponent;
    }

    public void addAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Action action = (Action)iterator.next();
            this.add(action);
        }
    }

    public void addAll(Action[] actionArray) {
        this.addAll(Arrays.asList(actionArray));
    }

    private void addAction(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    public void addStrut(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(n, 0, 0, 0);
        this.add(Box.createVerticalStrut(n), gridBagConstraints);
    }

    public void addSeparator() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        GradientSeparator gradientSeparator = GradientSeparator.createHorizontalGradient(Color.DARK_GRAY, Color.DARK_GRAY);
        this.add((Component)gradientSeparator, gridBagConstraints);
    }

    private JComponent createActionComponent(Action action) {
        ActionLabel actionLabel = new ActionLabel(action);
        actionLabel.setBorder(new EmptyBorder(4, 7, 3, 7));
        actionLabel.setIcon(this.getIconFor(action));
        actionLabel.setToolTipText(null);
        return actionLabel;
    }

    private Icon getIconFor(Action action) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        return this.forceDefaultIcon || null == icon ? this.defaultIcon : icon;
    }
}

