/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.panel;

import com.jgoodies.uifextras.util.TableUtilities;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class PropertiesTable
extends JPanel {
    protected JTable table;
    protected String[] headers;
    protected Object[][] data;
    private final MyTableModel model;

    public PropertiesTable(Properties properties, String[] stringArray) {
        super(new GridLayout(0, 1));
        this.headers = stringArray;
        this.model = new MyTableModel();
        this.setData(properties);
        this.build();
    }

    protected void build() {
        this.table = new JTable(this.model);
        this.table.setAutoResizeMode(this.getAutoResizeMode());
        TableUtilities.resizeColumnsToPreferredWidth(this.table);
        TableUtilities.leftAlignColumn(this.table.getColumnModel().getColumn(1));
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setEnabled(true);
        this.table.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.table.addMouseListener(mouseListener);
    }

    protected int getAutoResizeMode() {
        return 4;
    }

    public MyTableModel getTableModel() {
        return this.model;
    }

    public void setData(Properties properties) {
        this.data = new Object[properties.size()][2];
        int n = 0;
        Enumeration enumeration = this.sort(properties.keys());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.data[n][0] = string;
            this.data[n][1] = properties.get(string);
            ++n;
        }
        this.model.updateData();
    }

    private Enumeration sort(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList(20);
        Enumeration enumeration2 = enumeration;
        while (enumeration2.hasMoreElements()) {
            arrayList.add(enumeration2.nextElement());
        }
        Collections.sort(arrayList);
        return Collections.enumeration(arrayList);
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public int getColumnCount() {
            return PropertiesTable.this.headers.length;
        }

        public int getRowCount() {
            return PropertiesTable.this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return n < PropertiesTable.this.data.length ? PropertiesTable.this.data[n][n2] : null;
        }

        public String getColumnName(int n) {
            return PropertiesTable.this.headers[n];
        }

        public void updateData() {
            this.fireTableDataChanged();
        }
    }
}

