/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.printing;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;

public class HTMLTableWriter {
    private static final String FONT_DESCRIPTION = "<FONT size=-2>";
    private final String lineSeparator = System.getProperty("line.separator");
    private Writer out;
    private TableModel model;
    private int[] columnAlignments = null;
    private boolean trouble = false;

    public int getColumnAlignment(int n) {
        return null == this.columnAlignments ? 2 : this.columnAlignments[n];
    }

    public void setColumnAlignments(int[] nArray) {
        this.columnAlignments = nArray;
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    private void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    private void newLine() {
        try {
            this.out.write(this.lineSeparator);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void print(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void println(String string) {
        this.print(string);
        this.newLine();
    }

    protected void writeFontEndTag() {
        this.print("</FONT>");
    }

    protected void writeFontStartTag() {
        this.print(FONT_DESCRIPTION);
    }

    public void writePage(Writer writer, TableModel tableModel) {
        this.out = writer;
        this.model = tableModel;
        this.println("<HTML>");
        this.println("<HEAD><TITLE>title</TITLE></HEAD>");
        this.println("<BODY>");
        this.writeTable(writer, tableModel);
        this.println("</BODY>");
        this.println("</HTML>");
        this.flush();
    }

    public void writeTable(Writer writer, TableModel tableModel) {
        this.out = writer;
        this.model = tableModel;
        this.println("<TABLE border=0 cellpadding=0 cellspacing=0>");
        int n = tableModel.getRowCount();
        this.writeTableHeader();
        for (int i = 0; i < n; ++i) {
            this.writeTableRow(i);
        }
        this.println("</TABLE>");
        this.flush();
    }

    public void writeTableCellHTML(Object object, int n) {
        this.print("<td valign=top align=");
        this.print(this.getColumnAlignment(n) == 2 ? "left" : "right");
        this.print(">");
        if (n > 3) {
            this.print("&nbsp;");
        }
        this.print("<font=\"arial,helvetica\" size=-2>");
        this.print(object.toString());
        this.writeFontEndTag();
        this.println("</td>");
    }

    private void writeTableHeader() {
        this.print("<TR>");
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.writeTableHeaderCellHTML(this.model.getColumnName(i));
        }
        this.println("</TR>");
    }

    public void writeTableHeaderCellHTML(Object object) {
        this.print("<th>");
        this.print("&nbsp;");
        this.writeFontStartTag();
        this.print(object.toString());
        this.writeFontEndTag();
        this.print("&nbsp;");
        this.println("</th>");
    }

    private void writeTableRow(int n) {
        this.print("<TR>");
        int n2 = this.model.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            this.writeTableCellHTML(this.model.getValueAt(n, i), i);
        }
        this.println("</TR>");
    }
}

