/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.printing;

import com.jgoodies.uif.application.Application;
import com.jgoodies.uifextras.printing.PrintableDocument;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public final class PrintManager {
    private static final String PAGE_FORMAT_KEY = "pageFormat";
    private static PageFormat pageFormat;
    private static Logger logger;

    private PrintManager() {
    }

    public static PageFormat getPageFormat() {
        Preferences preferences;
        if (null == pageFormat && (pageFormat = PrintManager.decodePageFormatFrom((preferences = Application.getUserPreferences()).get(PAGE_FORMAT_KEY, null))) == null) {
            pageFormat = PrintManager.defaultPageFormat();
        }
        return pageFormat;
    }

    private static PageFormat defaultPageFormat() {
        return PrinterJob.getPrinterJob().defaultPage();
    }

    public static void setPageFormat(PageFormat pageFormat) {
        PrintManager.pageFormat = pageFormat;
        Application.getUserPreferences().put(PAGE_FORMAT_KEY, PrintManager.encodePageFormat(pageFormat));
    }

    public static void openPageSetupDialog() {
        pageFormat = PrinterJob.getPrinterJob().pageDialog(PrintManager.getPageFormat());
    }

    static void print(PrintableDocument printableDocument, boolean bl) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        pageFormat = printerJob.validatePage(PrintManager.getPageFormat());
        Book book = printableDocument.createBook(PrintManager.getPageFormat());
        if (null == book) {
            return;
        }
        printerJob.setPageable(book);
        printerJob.setJobName(printableDocument.getJobName());
        if (bl && !printerJob.printDialog()) {
            return;
        }
        try {
            printerJob.print();
        }
        catch (PrinterException printerException) {
            logger.log(Level.WARNING, "A printing problem occured.", printerException);
        }
        catch (Exception exception) {
            logger.severe("A severe printing problem occured: " + exception.getLocalizedMessage());
        }
    }

    private static String encodePageFormat(PageFormat pageFormat) {
        Paper paper = pageFormat.getPaper();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + pageFormat.getOrientation());
        stringBuffer.append("|" + paper.getWidth());
        stringBuffer.append("|" + paper.getHeight());
        stringBuffer.append("|" + paper.getImageableX());
        stringBuffer.append("|" + paper.getImageableY());
        stringBuffer.append("|" + paper.getImageableWidth());
        stringBuffer.append("|" + paper.getImageableHeight());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static PageFormat decodePageFormatFrom(String string) {
        if (null == string) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[|]");
        PageFormat pageFormat = PrintManager.defaultPageFormat();
        Paper paper = new Paper();
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            double d = Double.parseDouble(stringTokenizer.nextToken());
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            double d3 = Double.parseDouble(stringTokenizer.nextToken());
            double d4 = Double.parseDouble(stringTokenizer.nextToken());
            double d5 = Double.parseDouble(stringTokenizer.nextToken());
            double d6 = Double.parseDouble(stringTokenizer.nextToken());
            pageFormat.setOrientation(n);
            paper.setSize(d, d2);
            paper.setImageableArea(d3, d4, d5, d6);
            pageFormat.setPaper(paper);
            return pageFormat;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Can't decode page format.", exception);
            return null;
        }
    }

    static {
        logger = Logger.getLogger("PrintManager");
    }
}

