/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.printing;

import com.jgoodies.uifextras.printing.HTMLTableWriter;
import com.jgoodies.uifextras.printing.PrintManager;
import com.jgoodies.uifextras.util.ExtTable;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;

public final class PrintableDocument
implements Printable {
    private static final int CONFIRM_PRINT_LIMIT = 10;
    private static final int MAX_PRINTABLE_PAGES = 500;
    private static final int HEADER_HEIGHT = 25;
    private static final int FOOTER_HEIGHT = 25;
    private static Logger logger = Logger.getLogger("PrintableDocument");
    private Component component;
    private boolean centerOutput;
    private String header;
    private String footer;
    private String jobName;
    private Book book;

    public PrintableDocument(Component component, boolean bl) {
        this("", component, bl);
    }

    public PrintableDocument(String string, Component component, boolean bl) {
        this.component = component;
        this.centerOutput = bl;
        this.setHeader(string);
    }

    public static PrintableDocument createFrom(URL uRL) {
        JEditorPane jEditorPane = UIFactory.createHTMLPane(false, false);
        try {
            jEditorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Can't print URL " + uRL, iOException);
        }
        String string = uRL.getFile();
        int n = string.lastIndexOf(47);
        String string2 = -1 == n ? string : string.substring(n + 1);
        PrintableDocument printableDocument = new PrintableDocument(string2, jEditorPane, false);
        printableDocument.setJobName(string2);
        return printableDocument;
    }

    public static PrintableDocument createFrom(TableModel tableModel, int[] nArray) {
        StringWriter stringWriter = new StringWriter();
        HTMLTableWriter hTMLTableWriter = new HTMLTableWriter();
        hTMLTableWriter.setColumnAlignments(nArray);
        hTMLTableWriter.writeTable(stringWriter, tableModel);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(stringWriter.toString());
        return new PrintableDocument(null, jEditorPane, false);
    }

    public static PrintableDocument createFrom(ExtTable extTable) {
        return PrintableDocument.createFrom(extTable.getModel(), extTable.getColumnAlignments());
    }

    public boolean getCenterOutput() {
        return this.centerOutput;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public void setFooter(String string) {
        this.footer = string;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String string) {
        this.jobName = string;
    }

    public void print() {
        PrintManager.print(this, false);
    }

    public void printWithDialog() {
        PrintManager.print(this, true);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        int n4 = (int)pageFormat.getImageableWidth();
        int n5 = (int)pageFormat.getImageableHeight();
        int n6 = n5 - 25 - 25;
        int n7 = this.book.getNumberOfPages();
        Component component = this.getComponent();
        Font font = new Font("dialog", 0, 8);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.header != null) {
            graphics.drawString(this.header, n2, n3 + fontMetrics.getAscent());
        }
        String string = "Page " + (n + 1) + " of " + n7;
        int n8 = fontMetrics.stringWidth(string) + 2;
        graphics.drawString(string, n2 + n4 - n8, n3 + fontMetrics.getAscent());
        if (this.footer != null) {
            graphics.drawString(this.footer, n2, n3 + n5);
        }
        graphics.setClip(n2, n3 + 25, n4, n6);
        if (n7 == 1 && this.getCenterOutput()) {
            graphics.translate(n2 + (n4 - component.getSize().width) / 2, n3 + 25 + (n6 - component.getSize().height) / 2);
        } else {
            graphics.translate(n2, n3 + 25 - n * n6);
        }
        component.print(graphics);
        return 0;
    }

    private static boolean checkPageLimit(int n) {
        if (n <= 10) {
            return true;
        }
        if (n > 500) {
            return false;
        }
        int n2 = JOptionPane.showConfirmDialog(null, "Do you really want to print " + n + " pages?", null, 0);
        return 0 == n2;
    }

    Book createBook(PageFormat pageFormat) {
        double d = pageFormat.getImageableWidth();
        double d2 = pageFormat.getImageableHeight();
        double d3 = d2 - 25.0 - 25.0;
        this.doLayout((int)d);
        Dimension dimension = this.getSize();
        int n = (int)((double)dimension.height / d3) + 1;
        logger.info("Imageable X:      " + pageFormat.getImageableX());
        logger.info("Imageable Y:      " + pageFormat.getImageableY());
        logger.info("Imageable width:  " + d);
        logger.info("Imageable height: " + d2 + "; Header= " + 25 + "; component= " + d3 + "; footer=" + 25);
        logger.info("Component width:  " + dimension.width);
        logger.info("Component height: " + dimension.height);
        logger.info("Number of pages:  " + n);
        if (!PrintableDocument.checkPageLimit(n)) {
            return null;
        }
        this.book = new Book();
        this.book.append(this, pageFormat, n);
        return this.book;
    }

    private void doLayout(int n) {
        Dimension dimension = this.getSize();
        if (0 == dimension.width || 0 == dimension.height) {
            Component component = this.getComponent();
            component.setSize(n, Integer.MAX_VALUE);
            if (component instanceof JEditorPane) {
                JEditorPane jEditorPane = (JEditorPane)component;
                Dimension dimension2 = ((Component)jEditorPane).getPreferredSize();
                component.setSize(n, dimension2.height);
            }
            dimension = component.getSize();
        }
    }

    private Dimension getSize() {
        return this.getComponent().getSize();
    }
}

