/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.util;

import com.jgoodies.uif.component.UIFLabel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;

public final class ActionLabel
extends UIFLabel {
    private Color linkColor;
    private Color backgroundColor;
    private Color linkColorSave;
    private Color backgroundColorSave;
    private boolean active = false;
    private ActionListener actionListener = null;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public ActionLabel(String string) {
        this(string, Color.BLUE, null);
    }

    public ActionLabel(String string, Icon icon, int n) {
        this(string, Color.BLUE, null, icon, n);
    }

    public ActionLabel(String string, Color color, Color color2) {
        this(string, color, color2, null, 10);
    }

    public ActionLabel(String string, Color color, Color color2, Icon icon, int n) {
        super(string, false);
        this.setLinkColor(color);
        this.setBackgroundColor(color2);
        this.addMouseListener(new ActionMouseAdapter());
        this.setIcon(icon);
        this.setHorizontalAlignment(n);
    }

    public ActionLabel(Action action) {
        this((String)action.getValue("ShortDescription"), (Icon)action.getValue("SmallIcon"), 2);
        this.configurePropertiesFromAction(action);
        this.setAction(action);
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(Color color) {
        this.linkColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        Action action2 = this.action;
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionLabel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = new ActionPropertyChangeHandler(this);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl = false;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != clazz || objectArray[i + 1] != actionListener) continue;
            bl = true;
        }
        return bl;
    }

    private void configurePropertiesFromAction(Action action) {
        this.configurePropertiesFromAction(action, null);
    }

    private void configurePropertiesFromAction(Action action, String[] stringArray) {
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"Name", "ShortDescription", "SmallIcon", "ActionCommandKey", "enabled"};
            stringArray = stringArray2;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            if (string.equals("MnemonicKey")) {
                Integer n = action == null ? null : (Integer)action.getValue(string);
                this.setDisplayedMnemonic(n == null ? 0 : n);
                continue;
            }
            if (string.equals("Name")) {
                this.setText(action != null ? (String)action.getValue(string) : null);
                continue;
            }
            if (string.equals("ShortDescription")) {
                this.setToolTipText(action != null ? (String)action.getValue(string) : null);
                continue;
            }
            if (string.equals("SmallIcon")) {
                this.setIcon(action != null ? (Icon)action.getValue(string) : null);
                continue;
            }
            if (!string.equals("enabled")) continue;
            this.setEnabled(action != null ? action.isEnabled() : true);
        }
    }

    public Icon getDisabledIcon() {
        Icon icon = super.getDisabledIcon();
        if (icon != null) {
            return icon;
        }
        Icon icon2 = this.getIcon();
        if (icon2 != null && icon2 instanceof ImageIcon) {
            IconUIResource iconUIResource = new IconUIResource(new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon2).getImage())));
            this.setDisabledIcon(iconUIResource);
            return iconUIResource;
        }
        return icon2;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.active && this.isEnabled()) {
            graphics.setColor(this.linkColor);
            this.paintUnderline(graphics);
        }
    }

    private void paintUnderline(Graphics graphics) {
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.right + insets.left), this.getHeight() - (insets.bottom + insets.top));
        SwingUtilities.layoutCompoundLabel((JComponent)((Object)this), fontMetrics, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle2, new Rectangle(), rectangle, this.getText() == null ? 0 : (Integer)UIManager.get("Button.textIconGap"));
        graphics.fillRect(rectangle.x, rectangle.y + fontMetrics.getAscent() + 1, rectangle.width, 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ActionPropertyChangeHandler
    implements PropertyChangeListener {
        private ActionLabel label;

        ActionPropertyChangeHandler(ActionLabel actionLabel) {
            this.label = actionLabel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                Object object = this.label.getClientProperty("hideActionText");
                if (!Boolean.TRUE.equals(object)) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    this.label.setText(string2);
                    this.label.repaint();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                this.label.setToolTipText(string3);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.label.setEnabled(bl);
                this.label.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.label.setIcon(icon);
                this.label.invalidate();
                this.label.repaint();
            }
        }
    }

    private class ActionMouseAdapter
    extends MouseAdapter {
        private ActionMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!ActionLabel.this.isEnabled()) {
                return;
            }
            if (ActionLabel.this.actionListener != null) {
                ActionLabel.this.actionListener.actionPerformed(new ActionEvent((Object)ActionLabel.this, 1001, "Clicked"));
                this.deactivateIfNotShowing();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.activateLink();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.deactivateLink();
        }

        private void deactivateIfNotShowing() {
            if (!ActionLabel.this.isShowing()) {
                this.deactivateLink();
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!ActionLabel.this.isShowing()) {
                        this.deactivateLink();
                    }
                }
            });
        }

        private void activateLink() {
            ActionLabel.this.active = true;
            ActionLabel.this.linkColorSave = ActionLabel.this.getForeground();
            ActionLabel.this.setForeground(ActionLabel.this.linkColor);
            ActionLabel.this.backgroundColorSave = ActionLabel.this.getBackground();
            if (ActionLabel.this.backgroundColor != null) {
                ActionLabel.this.setBackground(ActionLabel.this.backgroundColor);
            }
            ActionLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            ActionLabel.this.repaint();
        }

        private void deactivateLink() {
            ActionLabel.this.active = false;
            ActionLabel.this.setForeground(ActionLabel.this.linkColorSave);
            ActionLabel.this.setBackground(ActionLabel.this.backgroundColorSave);
            ActionLabel.this.setCursor(null);
            ActionLabel.this.repaint();
        }
    }
}

