/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public final class GradientSeparator
extends JComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 90;
    public static final float LEFT = 0.0f;
    public static final float TOP = 0.0f;
    public static final float MIDDLE = 0.5f;
    public static final float CENTER = 0.5f;
    public static final float RIGHT = 1.0f;
    public static final float BOTTOM = 1.0f;
    private int orientation;
    private Color startColor;
    private Color middleColor;
    private Color stopColor;
    private float middleProportion;

    public GradientSeparator(int n, Color color, Color color2, Color color3, float f) {
        this.orientation = n;
        this.startColor = color;
        this.middleColor = color2;
        this.stopColor = color3;
        this.middleProportion = f;
        if (n != 0 && n != 90) {
            throw new IllegalArgumentException("The gradient orientation must be horizontal or vertical.");
        }
        if (color == null) {
            throw new NullPointerException("The gradient start color must not be null.");
        }
        if (color2 == null) {
            throw new NullPointerException("The gradient middle color must not be null.");
        }
        if (color3 == null) {
            throw new NullPointerException("The gradient stop color must not be null.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The middle location must be in [0, 1].");
        }
    }

    public static GradientSeparator createSingleHorizontalGradient(Color color, Color color2) {
        return new GradientSeparator(0, color, color2, color2, 0.0f);
    }

    public static GradientSeparator createHorizontalGradient(Color color) {
        return GradientSeparator.createHorizontalGradient(GradientSeparator.asTransparentColor(color), color);
    }

    public static GradientSeparator createHorizontalGradient(Color color, Color color2) {
        return GradientSeparator.createHorizontalGradient(color, color2, color);
    }

    public static GradientSeparator createHorizontalGradient(Color color, Color color2, Color color3) {
        return new GradientSeparator(0, color, color2, color3, 0.5f);
    }

    public static GradientSeparator createSingleVerticalGradient(Color color, Color color2) {
        return new GradientSeparator(90, color, color2, color2, 1.0f);
    }

    public static GradientSeparator createVerticalGradient(Color color) {
        return GradientSeparator.createVerticalGradient(GradientSeparator.asTransparentColor(color), color);
    }

    public static GradientSeparator createVerticalGradient(Color color, Color color2) {
        return GradientSeparator.createVerticalGradient(color, color2, color);
    }

    public static GradientSeparator createVerticalGradient(Color color, Color color2, Color color3) {
        return new GradientSeparator(90, color, color2, color3, 0.5f);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.orientation == 0) {
            int n3 = Math.round((float)n * this.middleProportion);
            if (this.middleProportion != 0.0f) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.startColor, n3, 0.0f, this.middleColor));
                graphics2D.fillRect(0, 0, n3, n2);
            }
            if (this.middleProportion != 1.0f) {
                graphics2D.setPaint(new GradientPaint(n3, 0.0f, this.middleColor, n, 0.0f, this.stopColor));
                graphics2D.fillRect(n3, 0, n, n2);
            }
        } else {
            int n4 = Math.round((float)n2 * this.middleProportion);
            if (this.middleProportion != 0.0f) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, n4, this.middleColor));
                graphics2D.fillRect(0, 0, n, n4);
            }
            if (this.middleProportion != 1.0f) {
                graphics2D.setPaint(new GradientPaint(0.0f, n4, this.middleColor, 0.0f, n2, this.stopColor));
                graphics2D.fillRect(0, n4, n, n2 - n4);
            }
        }
    }

    private static Color asTransparentColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
    }
}

