/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public abstract class PopupAdapter
extends MouseAdapter {
    private final boolean reusePopupMenu;
    private JPopupMenu popupMenu;
    private PropertyChangeListener lookChangeHandler;

    public PopupAdapter() {
        this(false);
    }

    public PopupAdapter(boolean bl) {
        this.reusePopupMenu = bl;
    }

    protected abstract JPopupMenu buildPopupMenu(MouseEvent var1);

    public void mousePressed(MouseEvent mouseEvent) {
        this.popupMenuIfTriggered(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.popupMenuIfTriggered(mouseEvent);
    }

    private void popupMenuIfTriggered(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = this.getPopupMenu(mouseEvent);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private JPopupMenu getPopupMenu(MouseEvent mouseEvent) {
        if (this.popupMenu == null || !this.reusePopupMenu) {
            this.popupMenu = this.buildPopupMenu(mouseEvent);
            this.ensureLookChangeHandlerRegistered();
        }
        return this.popupMenu;
    }

    private void ensureLookChangeHandlerRegistered() {
        if (this.lookChangeHandler == null) {
            this.lookChangeHandler = new LookAndFeelChangeHandler();
            UIManager.addPropertyChangeListener(this.lookChangeHandler);
        }
    }

    private class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PopupAdapter.this.popupMenu = null;
        }
    }
}

