/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.util;

import com.jgoodies.uifextras.util.UIFactory;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class TableUtilities {
    private TableUtilities() {
    }

    public static void leftAlignColumn(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setHorizontalAlignment(2);
        } else {
            tableColumn.setHeaderRenderer(UIFactory.createLeftAlignedDefaultHeaderRenderer());
        }
    }

    private static int getMaximumColumnWidth(TableModel tableModel, int n) {
        int n2 = 0;
        int n3 = tableModel.getRowCount();
        for (int i = 0; i < n3; ++i) {
            Object object = tableModel.getValueAt(i, n);
            String string = object == null ? "" : object.toString();
            JLabel jLabel = new JLabel(string);
            int n4 = ((Component)jLabel).getPreferredSize().width;
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return n2 + 6;
    }

    public static void resizeColumnsToPreferredWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        int n = tableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = TableUtilities.getMaximumColumnWidth(tableModel, i);
            tableColumn.setPreferredWidth(Math.max(50, n2));
        }
    }

    public static StringBuffer writeAsExportString(TableModel tableModel) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(500);
        int n2 = tableModel.getRowCount();
        int n3 = tableModel.getColumnCount();
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        for (n = 0; n < n3; ++n) {
            stringBuffer.append(tableModel.getColumnName(n));
            if (n >= n3 - 1) continue;
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append(tableModel.getValueAt(n, i));
                if (i >= n3 - 1) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }
}

