/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uifextras.util;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.uif.component.UIFLabel;
import com.jgoodies.uif.component.UIFSplitPane;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public final class UIFactory {
    private UIFactory() {
    }

    public static JLabel createBoldLabel(String string) {
        return UIFactory.createBoldLabel(string, 0);
    }

    public static JLabel createBoldLabel(String string, int n) {
        return UIFactory.createBoldLabel(string, n, UIManager.getColor("controlText"));
    }

    public static JLabel createBoldLabel(String string, int n, Color color) {
        return UIFactory.createBoldLabel(string, n, color, false);
    }

    public static JLabel createBoldLabel(String string, int n, Color color, boolean bl) {
        UIFLabel uIFLabel = new UIFLabel(string, 1, n, bl);
        uIFLabel.setForeground(color);
        return uIFLabel;
    }

    public static JLabel createPlainLabel(String string) {
        return UIFactory.createPlainLabel(string, UIManager.getColor("controlText"));
    }

    public static JLabel createPlainLabel(String string, Color color) {
        return UIFactory.createPlainLabel(string, color, false);
    }

    public static JLabel createPlainLabel(String string, Color color, boolean bl) {
        UIFLabel uIFLabel = new UIFLabel(string, 0, 0, bl);
        if (color != null) {
            uIFLabel.setForeground(color);
        }
        uIFLabel.setVerticalAlignment(3);
        return uIFLabel;
    }

    public static JTextField createReadOnlyTextField() {
        JTextField jTextField = new JTextField(){

            protected void processEvent(AWTEvent aWTEvent) {
            }
        };
        jTextField.setFocusable(false);
        jTextField.setEditable(false);
        jTextField.setOpaque(false);
        jTextField.setForeground(Color.BLACK);
        return jTextField;
    }

    public static JTextArea createMultilineLabel(String string) {
        JTextArea jTextArea = new JTextArea(string){

            protected void processEvent(AWTEvent aWTEvent) {
            }

            public void updateUI() {
                super.updateUI();
                this.setOpaque(false);
                this.setMargin(new Insets(0, 0, 0, 0));
                if (this.getForeground() instanceof UIResource) {
                    this.setForeground(UIManager.getColor("controlText"));
                }
            }
        };
        jTextArea.setFocusable(false);
        jTextArea.setBorder(Borders.EMPTY_BORDER);
        return jTextArea;
    }

    public static JTextArea createWrappedMultilineLabel(String string) {
        JTextArea jTextArea = UIFactory.createMultilineLabel(string);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        return jTextArea;
    }

    public static JEditorPane createHTMLPane(boolean bl, boolean bl2) {
        JEditorPane jEditorPane;
        if (bl2) {
            jEditorPane = new JEditorPane(){

                protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                }
            };
        } else {
            jEditorPane = new JEditorPane(){

                protected void processEvent(AWTEvent aWTEvent) {
                }
            };
            jEditorPane.setFocusable(false);
        }
        HTMLEditorKit hTMLEditorKit = bl ? new HTMLEditorKit() : new HTMLEditorKit(){

            public Document createDefaultDocument() {
                HTMLDocument hTMLDocument = (HTMLDocument)super.createDefaultDocument();
                hTMLDocument.setAsynchronousLoadPriority(-1);
                return hTMLDocument;
            }
        };
        jEditorPane.setEditorKit(hTMLEditorKit);
        jEditorPane.setEditable(false);
        return jEditorPane;
    }

    public static JComponent createTablePanel(JTable jTable) {
        Color color = UIManager.getColor("window");
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getViewport().setBackground(color);
        jScrollPane.setOpaque(false);
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel(null));
        jScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel(null));
        JPanel jPanel = new JPanel(new GridLayout(0, 1)){

            public void updateUI() {
                super.updateUI();
                this.setBackground(UIManager.getColor("window"));
            }
        };
        jPanel.setPreferredSize(new Dimension(220, 100));
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public static TableCellRenderer createLeftAlignedDefaultHeaderRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setText(object == null ? "" : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(2);
        return defaultTableCellRenderer;
    }

    public static JSplitPane createStrippedSplitPane(int n, Component component, Component component2, double d) {
        UIFSplitPane uIFSplitPane = UIFSplitPane.createStrippedSplitPane((int)n, (Component)component, (Component)component2);
        uIFSplitPane.setResizeWeight(d);
        return uIFSplitPane;
    }

    public static JScrollPane createStrippedScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return jScrollPane;
    }

    public static Color getLightBackground() {
        Color color = UIManager.getColor("control");
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[2];
        return f2 > 0.95f ? Color.WHITE : Color.getHSBColor(f, f < 0.01f ? 0.0f : 0.03f, 0.97f);
    }
}

