/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding;

import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PresentationModel
extends Model {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_TRIGGERCHANNEL = "triggerChannel";
    public static final String PROPERTYNAME_BUFFERING = "buffering";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final BeanAdapter beanAdapter;
    private ValueModel triggerChannel;
    private final Map wrappedBuffers;
    private final PropertyChangeListener bufferingUpdateHandler;
    private boolean buffering = false;
    private final PropertyChangeListener changedUpdateHandler;
    private boolean changed = false;

    public PresentationModel(Object object) {
        this(new ValueHolder(object, true));
    }

    public PresentationModel(Object object, ValueModel valueModel) {
        this(new ValueHolder(object, true), valueModel);
    }

    public PresentationModel(ValueModel valueModel) {
        this(valueModel, (ValueModel)new Trigger());
    }

    public PresentationModel(ValueModel valueModel, ValueModel valueModel2) {
        this.beanChannel = valueModel;
        this.beanAdapter = new BeanAdapter(valueModel, true);
        this.triggerChannel = valueModel2;
        this.wrappedBuffers = new HashMap();
        this.bufferingUpdateHandler = new BufferingStateHandler();
        this.changed = false;
        this.changedUpdateHandler = new UpdateHandler();
        this.beanAdapter.addPropertyChangeListener(new BeanChangeHandler());
        this.observeChanged(this.beanAdapter, PROPERTYNAME_CHANGED);
    }

    public final ValueModel getBeanChannel() {
        return this.beanChannel;
    }

    public final Object getBean() {
        return this.getBeanChannel().getValue();
    }

    public final void setBean(Object object) {
        this.getBeanChannel().setValue(object);
    }

    public void beforeBeanChange(Object object, Object object2) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, object, object2);
    }

    public void afterBeanChange(Object object, Object object2) {
        this.setChanged(false);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, object, object2);
    }

    public final AbstractValueModel getModel(String string) {
        return this.beanAdapter.getValueModel(string);
    }

    public final ValueModel getModel(String string, String string2, String string3) {
        return this.beanAdapter.getValueModel(string, string2, string3);
    }

    public final BufferedValueModel getBufferedModel(String string) {
        return this.getBufferedModel(string, null, null);
    }

    public final BufferedValueModel getBufferedModel(String string, String string2, String string3) {
        WrappedBuffer wrappedBuffer = (WrappedBuffer)this.wrappedBuffers.get(string);
        if (wrappedBuffer == null) {
            wrappedBuffer = new WrappedBuffer(this.buffer(this.getModel(string, string2, string3)), string2, string3);
            this.wrappedBuffers.put(string, wrappedBuffer);
        } else if (!this.equals(string2, wrappedBuffer.getterName) || !this.equals(string3, wrappedBuffer.setterName)) {
            throw new IllegalArgumentException("You must not invoke this method twice with different getter and/or setter names.");
        }
        return wrappedBuffer.buffer;
    }

    private BufferedValueModel buffer(ValueModel valueModel) {
        BufferedValueModel bufferedValueModel = new BufferedValueModel(valueModel, this.getTriggerChannel());
        bufferedValueModel.addPropertyChangeListener(PROPERTYNAME_BUFFERING, this.bufferingUpdateHandler);
        return bufferedValueModel;
    }

    public final ValueModel getTriggerChannel() {
        return this.triggerChannel;
    }

    public final void setTriggerChannel(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The trigger channel must not be null.");
        }
        ValueModel valueModel2 = this.getTriggerChannel();
        this.triggerChannel = valueModel;
        Iterator iterator = this.wrappedBuffers.values().iterator();
        while (iterator.hasNext()) {
            WrappedBuffer wrappedBuffer = (WrappedBuffer)iterator.next();
            wrappedBuffer.buffer.setTriggerChannel(this.triggerChannel);
        }
        this.firePropertyChange(PROPERTYNAME_TRIGGERCHANNEL, valueModel2, valueModel);
    }

    public final void triggerCommit() {
        if (Boolean.TRUE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue(Boolean.TRUE);
    }

    public final void triggerFlush() {
        if (Boolean.FALSE.equals(this.getTriggerChannel().getValue())) {
            this.getTriggerChannel().setValue(null);
        }
        this.getTriggerChannel().setValue(Boolean.FALSE);
    }

    public final boolean isBuffering() {
        return this.buffering;
    }

    private void setBuffering(boolean bl) {
        boolean bl2 = this.isBuffering();
        this.buffering = bl;
        this.firePropertyChange(PROPERTYNAME_BUFFERING, bl2, bl);
    }

    private void updateBufferingState(boolean bl) {
        if (this.buffering == bl) {
            return;
        }
        boolean bl2 = false;
        Iterator iterator = this.wrappedBuffers.values().iterator();
        while (iterator.hasNext()) {
            WrappedBuffer wrappedBuffer = (WrappedBuffer)iterator.next();
            BufferedValueModel bufferedValueModel = wrappedBuffer.buffer;
            boolean bl3 = bl2 = bl2 || bufferedValueModel.isBuffering();
            if (this.buffering || !bl2) continue;
            this.setBuffering(true);
            return;
        }
        this.setBuffering(bl2);
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
        this.beanAdapter.resetChanged();
    }

    protected void setChanged(boolean bl) {
        boolean bl2 = this.isChanged();
        this.changed = bl;
        this.firePropertyChange(PROPERTYNAME_CHANGED, bl2, bl);
    }

    public void observeChanged(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.addPropertyChangeListener(object, string, this.changedUpdateHandler);
    }

    public void observeChanged(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.addValueChangeListener(this.changedUpdateHandler);
    }

    public void retractInterestFor(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.removePropertyChangeListener(object, string, this.changedUpdateHandler);
    }

    public void retractInterestFor(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.removeValueChangeListener(this.changedUpdateHandler);
    }

    public synchronized void addBeanPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.beanAdapter.addBeanPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeBeanPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.beanAdapter.removeBeanPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addBeanPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.beanAdapter.addBeanPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removeBeanPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.beanAdapter.removeBeanPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners() {
        return this.beanAdapter.getBeanPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners(String string) {
        return this.beanAdapter.getBeanPropertyChangeListeners(string);
    }

    private class UpdateHandler
    implements PropertyChangeListener {
        private UpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!PresentationModel.PROPERTYNAME_CHANGED.equals(string) || ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                PresentationModel.this.setChanged(true);
            }
        }
    }

    private class BufferingStateHandler
    implements PropertyChangeListener {
        private BufferingStateHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PresentationModel.this.updateBufferingState((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if (PresentationModel.PROPERTYNAME_BEFORE_BEAN.equals(string)) {
                PresentationModel.this.beforeBeanChange(object, object2);
            } else if (PresentationModel.PROPERTYNAME_BEAN.equals(string)) {
                PresentationModel.this.firePropertyChange(PresentationModel.PROPERTYNAME_BEAN, object, object2);
            } else if (PresentationModel.PROPERTYNAME_AFTER_BEAN.equals(string)) {
                PresentationModel.this.afterBeanChange(object, object2);
            }
        }
    }

    private static class WrappedBuffer {
        private final BufferedValueModel buffer;
        private final String getterName;
        private final String setterName;

        WrappedBuffer(BufferedValueModel bufferedValueModel, String string, String string2) {
            this.buffer = bufferedValueModel;
            this.getterName = string;
            this.setterName = string2;
        }
    }
}

