/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractTableAdapter
extends AbstractTableModel {
    private final ListModel listModel;
    private final String[] columnNames;

    public AbstractTableAdapter(ListModel listModel) {
        this(listModel, null);
    }

    public AbstractTableAdapter(ListModel listModel, String[] stringArray) {
        this.listModel = listModel;
        if (listModel == null) {
            throw new NullPointerException("The list model must not be null.");
        }
        if (stringArray == null) {
            this.columnNames = null;
        } else {
            this.columnNames = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.columnNames, 0, stringArray.length);
        }
        listModel.addListDataListener(this.createChangeHandler());
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public final int getRowCount() {
        return this.listModel.getSize();
    }

    protected final Object getRow(int n) {
        return this.listModel.getElementAt(n);
    }

    protected ListDataListener createChangeHandler() {
        return new ListDataChangeHandler();
    }

    private class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            AbstractTableAdapter.this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            AbstractTableAdapter.this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            AbstractTableAdapter.this.fireTableRowsUpdated(n, n2);
        }
    }
}

