/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.adapter.DocumentAdapter;
import com.jgoodies.binding.adapter.RadioButtonAdapter;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public final class Bindings {
    private static final FocusLostHandler FOCUS_LOST_HANDLER = new FocusLostHandler();
    private static final WeakTrigger FOCUS_LOST_TRIGGER = new WeakTrigger();

    private Bindings() {
    }

    public static void bind(JCheckBox jCheckBox, ValueModel valueModel) {
        boolean bl = jCheckBox.getModel().isEnabled();
        jCheckBox.setModel(new ToggleButtonAdapter(valueModel));
        jCheckBox.setEnabled(bl);
    }

    public static void bind(JToggleButton jToggleButton, ValueModel valueModel) {
        boolean bl = jToggleButton.getModel().isEnabled();
        jToggleButton.setModel(new ToggleButtonAdapter(valueModel));
        jToggleButton.setEnabled(bl);
    }

    public static void bind(JToggleButton jToggleButton, ValueModel valueModel, Object object, Object object2) {
        boolean bl = jToggleButton.getModel().isEnabled();
        jToggleButton.setModel(new ToggleButtonAdapter(valueModel, object, object2));
        jToggleButton.setEnabled(bl);
    }

    public static void bind(JCheckBoxMenuItem jCheckBoxMenuItem, ValueModel valueModel) {
        boolean bl = jCheckBoxMenuItem.getModel().isEnabled();
        jCheckBoxMenuItem.setModel(new ToggleButtonAdapter(valueModel));
        jCheckBoxMenuItem.setEnabled(bl);
    }

    public static void bind(JComboBox jComboBox, SelectionInList selectionInList) {
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        jComboBox.setModel(new ComboBoxAdapter(selectionInList));
    }

    public static void bind(JFormattedTextField jFormattedTextField, ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        PropertyConnector propertyConnector = new PropertyConnector(valueModel, "value", jFormattedTextField, "value");
        propertyConnector.updateProperty2();
    }

    public static void bind(JLabel jLabel, ValueModel valueModel) {
        PropertyConnector propertyConnector = new PropertyConnector(valueModel, "value", jLabel, "text");
        propertyConnector.updateProperty2();
    }

    public static void bind(JList jList, SelectionInList selectionInList) {
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        jList.setModel(selectionInList);
        jList.setSelectionModel(new SingleListSelectionAdapter(selectionInList.getSelectionIndexHolder()));
    }

    public static void bind(JRadioButton jRadioButton, ValueModel valueModel, Object object) {
        boolean bl = jRadioButton.getModel().isEnabled();
        jRadioButton.setModel(new RadioButtonAdapter(valueModel, object));
        jRadioButton.setEnabled(bl);
    }

    public static void bind(JRadioButtonMenuItem jRadioButtonMenuItem, ValueModel valueModel, Object object) {
        boolean bl = jRadioButtonMenuItem.getModel().isEnabled();
        jRadioButtonMenuItem.setModel(new RadioButtonAdapter(valueModel, object));
        jRadioButtonMenuItem.setEnabled(bl);
    }

    public static void bind(JTextComponent jTextComponent, ValueModel valueModel) {
        Bindings.bind(jTextComponent, valueModel, false);
    }

    public static void bind(JTextComponent jTextComponent, ValueModel valueModel, boolean bl) {
        Bindings.bind(jTextComponent, valueModel, new PlainDocument(), bl);
    }

    public static void bind(JTextComponent jTextComponent, ValueModel valueModel, Document document, boolean bl) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        ValueModel valueModel2 = bl ? Bindings.createCommitOnFocusLostModel(valueModel, jTextComponent) : valueModel;
        boolean bl2 = jTextComponent instanceof JTextField;
        jTextComponent.setDocument(new DocumentAdapter(valueModel2, document, bl2));
    }

    private static ValueModel createCommitOnFocusLostModel(ValueModel valueModel, Component component) {
        if (valueModel == null) {
            throw new NullPointerException("The value model must not be null.");
        }
        BufferedValueModel bufferedValueModel = new BufferedValueModel(valueModel, FOCUS_LOST_TRIGGER);
        component.addFocusListener(FOCUS_LOST_HANDLER);
        return bufferedValueModel;
    }

    private static final class WeakPropertyChangeSupport
    extends PropertyChangeSupport {
        private static final ReferenceQueue QUEUE = new ReferenceQueue();

        WeakPropertyChangeSupport(Object object) {
            super(object);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            WeakPropertyChangeSupport.cleanUp();
            if (propertyChangeListener == null) {
                return;
            }
            if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
                this.addPropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
            } else {
                super.addPropertyChangeListener(new WeakPropertyChangeListener(propertyChangeListener));
            }
        }

        public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            WeakPropertyChangeSupport.cleanUp();
            if (propertyChangeListener == null) {
                return;
            }
            super.addPropertyChangeListener(string, new WeakPropertyChangeListener(string, propertyChangeListener));
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            WeakPropertyChangeSupport.cleanUp();
            if (propertyChangeListener == null) {
                return;
            }
            if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
                this.removePropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
                return;
            }
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
            for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener weakPropertyChangeListener;
                if (propertyChangeListenerArray[i] instanceof PropertyChangeListenerProxy || (weakPropertyChangeListener = (WeakPropertyChangeListener)propertyChangeListenerArray[i]).get() != propertyChangeListener) continue;
                super.removePropertyChangeListener(weakPropertyChangeListener);
                break;
            }
        }

        public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            WeakPropertyChangeSupport.cleanUp();
            if (propertyChangeListener == null) {
                return;
            }
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners(string);
            for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener weakPropertyChangeListener = (WeakPropertyChangeListener)propertyChangeListenerArray[i];
                if (weakPropertyChangeListener.get() != propertyChangeListener) continue;
                super.removePropertyChangeListener(string, weakPropertyChangeListener);
                break;
            }
        }

        public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(propertyChangeEvent);
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(string, object, object2);
        }

        private static void cleanUp() {
            WeakPropertyChangeListener weakPropertyChangeListener;
            while ((weakPropertyChangeListener = (WeakPropertyChangeListener)QUEUE.poll()) != null) {
                weakPropertyChangeListener.removeListener();
            }
        }

        void removeWeakPropertyChangeListener(WeakPropertyChangeListener weakPropertyChangeListener) {
            if (weakPropertyChangeListener.propertyName == null) {
                super.removePropertyChangeListener(weakPropertyChangeListener);
            } else {
                super.removePropertyChangeListener(weakPropertyChangeListener.propertyName, weakPropertyChangeListener);
            }
        }

        private final class WeakPropertyChangeListener
        extends WeakReference
        implements PropertyChangeListener {
            final String propertyName;

            private WeakPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this(null, propertyChangeListener);
            }

            private WeakPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
                super(propertyChangeListener, QUEUE);
                this.propertyName = string;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.get();
                if (propertyChangeListener != null) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }

            private void removeListener() {
                WeakPropertyChangeSupport.this.removeWeakPropertyChangeListener(this);
            }
        }
    }

    private static final class WeakTrigger
    implements ValueModel {
        private final transient WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport(this);
        private Boolean value = null;

        WeakTrigger() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            if (object != null && !(object instanceof Boolean)) {
                throw new IllegalArgumentException("Trigger values must be of type Boolean.");
            }
            Boolean bl = this.value;
            this.value = (Boolean)object;
            this.fireValueChange(bl, object);
        }

        public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            this.changeSupport.addPropertyChangeListener("value", propertyChangeListener);
        }

        public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
            if (propertyChangeListener == null) {
                return;
            }
            this.changeSupport.removePropertyChangeListener("value", propertyChangeListener);
        }

        private void fireValueChange(Object object, Object object2) {
            this.changeSupport.firePropertyChange("value", object, object2);
        }

        void triggerCommit() {
            if (Boolean.TRUE.equals(this.getValue())) {
                this.setValue(null);
            }
            this.setValue(Boolean.TRUE);
        }
    }

    private static class FocusLostHandler
    extends FocusAdapter {
        private FocusLostHandler() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                FOCUS_LOST_TRIGGER.triggerCommit();
            }
        }
    }
}

