/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ComboBoxAdapter
extends AbstractListModel
implements ComboBoxModel {
    private final SelectionInList selectionInList;
    private final ValueModel selectionHolder;

    public ComboBoxAdapter(List list, ValueModel valueModel) {
        this(new SelectionInList(list), valueModel, false);
    }

    public ComboBoxAdapter(ListModel listModel, ValueModel valueModel) {
        this(new SelectionInList(listModel), valueModel, false);
    }

    public ComboBoxAdapter(Object[] objectArray, ValueModel valueModel) {
        this(new SelectionInList(objectArray), valueModel, false);
    }

    public ComboBoxAdapter(ValueModel valueModel, ValueModel valueModel2) {
        this(new SelectionInList(valueModel), valueModel2, false);
    }

    public ComboBoxAdapter(SelectionInList selectionInList) {
        this(selectionInList, null, true);
    }

    protected ComboBoxAdapter(SelectionInList selectionInList, ValueModel valueModel, boolean bl) {
        if (!bl && valueModel == null) {
            throw new NullPointerException("The selection holder must not be null.");
        }
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        this.selectionInList = selectionInList;
        this.selectionHolder = valueModel;
        this.getSelectionHolder().addValueChangeListener(new SelectionChangeHandler());
        selectionInList.addListDataListener(new ListDataChangeHandler());
    }

    public Object getSelectedItem() {
        return this.getSelectionHolder().getValue();
    }

    public void setSelectedItem(Object object) {
        this.getSelectionHolder().setValue(object);
    }

    public int getSize() {
        return this.selectionInList.getSize();
    }

    public Object getElementAt(int n) {
        return this.selectionInList.getElementAt(n);
    }

    private ValueModel getSelectionHolder() {
        return this.selectionHolder != null ? this.selectionHolder : this.selectionInList;
    }

    private class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ComboBoxAdapter.this.fireIntervalAdded(ComboBoxAdapter.this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ComboBoxAdapter.this.fireIntervalRemoved(ComboBoxAdapter.this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }

    private class SelectionChangeHandler
    implements PropertyChangeListener {
        private SelectionChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, -1, -1);
        }
    }
}

