/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public final class DocumentAdapter
implements Document,
DocumentListener {
    private final ValueModel subject;
    private final Document delegate;
    private final SubjectValueChangeHandler subjectValueChangeHandler;

    public DocumentAdapter(ValueModel valueModel) {
        this(valueModel, new PlainDocument(), false);
    }

    public DocumentAdapter(ValueModel valueModel, boolean bl) {
        this(valueModel, new PlainDocument(), bl);
    }

    public DocumentAdapter(ValueModel valueModel, Document document) {
        this(valueModel, document, false);
    }

    public DocumentAdapter(ValueModel valueModel, Document document, boolean bl) {
        if (valueModel == null) {
            throw new NullPointerException("The subject must not be null.");
        }
        if (document == null) {
            throw new NullPointerException("The document must not be null.");
        }
        this.subject = valueModel;
        this.delegate = document;
        document.putProperty("filterNewlines", bl);
        this.subjectValueChangeHandler = new SubjectValueChangeHandler();
        document.addDocumentListener(this);
        valueModel.addValueChangeListener(this.subjectValueChangeHandler);
        this.setDocumentTextSilently(this.getSubjectText());
    }

    private void updateSubject() {
        this.setSubjectText(this.getDocumentText());
    }

    private String getDocumentText() {
        int n = this.delegate.getLength();
        try {
            return this.delegate.getText(0, n);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return "";
        }
    }

    private void setDocumentTextSilently(String string) {
        this.delegate.removeDocumentListener(this);
        try {
            if (this.delegate instanceof AbstractDocument) {
                ((AbstractDocument)this.delegate).replace(0, this.delegate.getLength(), string, null);
            } else {
                this.delegate.remove(0, this.delegate.getLength());
                this.delegate.insertString(0, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.delegate.addDocumentListener(this);
    }

    private String getSubjectText() {
        String string = (String)this.subject.getValue();
        return string == null ? "" : string;
    }

    private void setSubjectText(String string) {
        this.subjectValueChangeHandler.setUpdateLater(true);
        this.subject.setValue(string);
        this.subjectValueChangeHandler.setUpdateLater(false);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateSubject();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateSubject();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public int getLength() {
        return this.delegate.getLength();
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.delegate.addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.delegate.removeDocumentListener(documentListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.delegate.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.delegate.removeUndoableEditListener(undoableEditListener);
    }

    public Object getProperty(Object object) {
        return this.delegate.getProperty(object);
    }

    public void putProperty(Object object, Object object2) {
        this.delegate.putProperty(object, object2);
    }

    public void remove(int n, int n2) throws BadLocationException {
        this.delegate.remove(n, n2);
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        this.delegate.insertString(n, string, attributeSet);
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.delegate.getText(n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.delegate.getText(n, n2, segment);
    }

    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    public Position createPosition(int n) throws BadLocationException {
        return this.delegate.createPosition(n);
    }

    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    public void render(Runnable runnable) {
        this.delegate.render(runnable);
    }

    private class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private boolean updateLater;

        private SubjectValueChangeHandler() {
        }

        void setUpdateLater(boolean bl) {
            this.updateLater = bl;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            String string2 = DocumentAdapter.this.getDocumentText();
            Object object = propertyChangeEvent.getNewValue();
            String string3 = string = object == null ? DocumentAdapter.this.getSubjectText() : (String)object;
            if (BindingUtils.equals(string2, string)) {
                return;
            }
            if (this.updateLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DocumentAdapter.this.setDocumentTextSilently(string);
                    }
                });
            } else {
                DocumentAdapter.this.setDocumentTextSilently(string);
            }
        }
    }
}

