/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.AbstractValueModel;
import java.util.prefs.Preferences;

public class PreferencesAdapter
extends AbstractValueModel {
    private static final String ERROR_MSG = "Value must be a Boolean, Double, Float, Integer, Long, or String.";
    protected final Preferences prefs;
    protected final String key;
    protected final Class type;
    protected final Object defaultValue;
    double NULL_DOUBLE = Double.MIN_VALUE;
    float NULL_FLOAT = Float.MIN_VALUE;
    int NULL_INT = Integer.MIN_VALUE;
    long NULL_LONG = Long.MIN_VALUE;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    public PreferencesAdapter(Preferences preferences, String string, Object object) {
        if (preferences == null) {
            throw new NullPointerException("The Preferences must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("The key must not be null.");
        }
        if (object == null) {
            throw new NullPointerException("The default value must not be null.");
        }
        this.prefs = preferences;
        this.key = string;
        if (object instanceof Class) {
            this.type = (Class)object;
            this.defaultValue = null;
        } else {
            this.type = object.getClass();
            this.defaultValue = object;
        }
    }

    public Object getValue() {
        boolean bl;
        boolean bl2 = this.defaultValue == null;
        boolean bl3 = bl = this.prefs.get(this.key, null) != null;
        if (bl2 && !bl) {
            return null;
        }
        if (this.type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PreferencesAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return this.getBoolean();
        }
        if (this.type == (class$java$lang$Double == null ? (class$java$lang$Double = PreferencesAdapter.class$("java.lang.Double")) : class$java$lang$Double)) {
            if (bl2) {
                double d = this.prefs.getDouble(this.key, this.NULL_DOUBLE);
                if (d == this.NULL_DOUBLE) {
                    return null;
                }
                return new Double(d);
            }
            return new Double(this.getDouble());
        }
        if (this.type == (class$java$lang$Float == null ? (class$java$lang$Float = PreferencesAdapter.class$("java.lang.Float")) : class$java$lang$Float)) {
            if (bl2) {
                float f = this.prefs.getFloat(this.key, this.NULL_FLOAT);
                if (f == this.NULL_FLOAT) {
                    return null;
                }
                return new Float(f);
            }
            return new Float(this.getFloat());
        }
        if (this.type == (class$java$lang$Integer == null ? (class$java$lang$Integer = PreferencesAdapter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (bl2) {
                int n = this.prefs.getInt(this.key, this.NULL_INT);
                if (n == this.NULL_INT) {
                    return null;
                }
                return new Integer(n);
            }
            return new Integer(this.getInt());
        }
        if (this.type == (class$java$lang$Long == null ? (class$java$lang$Long = PreferencesAdapter.class$("java.lang.Long")) : class$java$lang$Long)) {
            if (bl2) {
                long l = this.prefs.getLong(this.key, this.NULL_LONG);
                if (l == this.NULL_LONG) {
                    return null;
                }
                return new Long(l);
            }
            return new Long(this.getLong());
        }
        if (this.type == (class$java$lang$String == null ? (class$java$lang$String = PreferencesAdapter.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getString();
        }
        throw new ClassCastException(ERROR_MSG);
    }

    public void setValue(Object object) {
        if (object == null) {
            this.prefs.remove(this.key);
        } else if (object instanceof Boolean) {
            this.setBoolean((Boolean)object);
        } else if (object instanceof Double) {
            this.setDouble((Double)object);
        } else if (object instanceof Float) {
            this.setFloat(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.setInt((Integer)object);
        } else if (object instanceof Long) {
            this.setLong((Long)object);
        } else if (object instanceof String) {
            this.setString((String)object);
        } else {
            throw new IllegalArgumentException(ERROR_MSG);
        }
    }

    public boolean getBoolean() {
        return this.prefs.getBoolean(this.key, (Boolean)this.defaultValue);
    }

    public double getDouble() {
        return this.prefs.getDouble(this.key, (Double)this.defaultValue);
    }

    public float getFloat() {
        return this.prefs.getFloat(this.key, ((Float)this.defaultValue).floatValue());
    }

    public int getInt() {
        return this.prefs.getInt(this.key, (Integer)this.defaultValue);
    }

    public long getLong() {
        return this.prefs.getLong(this.key, (Long)this.defaultValue);
    }

    public String getString() {
        return this.prefs.get(this.key, (String)this.defaultValue);
    }

    public void setBoolean(boolean bl) {
        Object object = this.getValue();
        this.prefs.putBoolean(this.key, bl);
        this.fireValueChange(object, new Boolean(bl));
    }

    public void setDouble(double d) {
        Object object = this.getValue();
        this.prefs.putDouble(this.key, d);
        this.fireValueChange(object, new Double(d));
    }

    public void setFloat(float f) {
        Object object = this.getValue();
        this.prefs.putFloat(this.key, f);
        this.fireValueChange(object, new Float(f));
    }

    public void setInt(int n) {
        Object object = this.getValue();
        this.prefs.putInt(this.key, n);
        this.fireValueChange(object, new Integer(n));
    }

    public void setLong(long l) {
        Object object = this.getValue();
        this.prefs.putLong(this.key, l);
        this.fireValueChange(object, new Long(l));
    }

    public void setString(String string) {
        Object object = this.getValue();
        this.prefs.put(this.key, string);
        this.fireValueChange(object, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

