/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class SingleListSelectionAdapter
implements ListSelectionModel {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private int firstAdjustedIndex = Integer.MAX_VALUE;
    private int lastAdjustedIndex = -1;
    private int firstChangedIndex = Integer.MAX_VALUE;
    private int lastChangedIndex = -1;
    private final ValueModel selectionIndexHolder;
    private boolean valueIsAdjusting;
    private final EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public SingleListSelectionAdapter(ValueModel valueModel) {
        this.selectionIndexHolder = valueModel;
        this.selectionIndexHolder.addValueChangeListener(new SelectionIndexChangeHandler());
    }

    private int getSelectionIndex() {
        Object object = this.selectionIndexHolder.getValue();
        return object == null ? -1 : (Integer)object;
    }

    private void setSelectionIndex(int n) {
        this.setSelectionIndex(this.getSelectionIndex(), n);
    }

    private void setSelectionIndex(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.markAsDirty(n);
        this.markAsDirty(n2);
        this.selectionIndexHolder.setValue(new Integer(n2));
        this.fireValueChanged();
    }

    public void setSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        this.setSelectionIndex(n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this.setSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        int n3 = Math.max(n, n2);
        int n4 = Math.min(n, n2);
        if (n4 <= this.getSelectionIndex() && this.getSelectionIndex() <= n3) {
            this.clearSelection();
        }
    }

    public int getMinSelectionIndex() {
        return this.getSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionIndex();
    }

    public boolean isSelectedIndex(int n) {
        return n < 0 ? false : n == this.getSelectionIndex();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionIndex();
    }

    public void setAnchorSelectionIndex(int n) {
        this.setSelectionIndex(n);
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionIndex();
    }

    public void setLeadSelectionIndex(int n) {
        this.setSelectionIndex(n);
    }

    public void clearSelection() {
        this.setSelectionIndex(-1);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionIndex() == -1;
    }

    public void insertIndexInterval(int n, int n2, boolean bl) {
        if (this.isSelectionEmpty()) {
            return;
        }
        int n3 = bl ? n : n + 1;
        int n4 = this.getSelectionIndex();
        if (n4 >= n3) {
            this.setSelectionIndex(n4 + n2);
        }
    }

    public void removeIndexInterval(int n, int n2) {
        if (n < -1 || n2 < -1) {
            throw new IndexOutOfBoundsException("Both indices must be greater or equals to -1.");
        }
        if (this.isSelectionEmpty()) {
            return;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = this.getSelectionIndex();
        if (n3 <= n5 && n5 <= n4) {
            this.clearSelection();
        } else if (n4 < n5) {
            int n6 = n5 - (n4 - n3 + 1);
            this.setSelectionInterval(n6, n6);
        }
    }

    public void setValueIsAdjusting(boolean bl) {
        boolean bl2 = this.valueIsAdjusting;
        if (bl2 == bl) {
            return;
        }
        this.valueIsAdjusting = bl;
        this.fireValueChanged(bl);
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setSelectionMode(int n) {
        if (n != 0) {
            throw new UnsupportedOperationException("The SingleListSelectionAdapter must be used in single selection mode.");
        }
    }

    public int getSelectionMode() {
        return 0;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = SingleListSelectionAdapter.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = SingleListSelectionAdapter.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = SingleListSelectionAdapter.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener);
    }

    private void markAsDirty(int n) {
        if (n < 0) {
            return;
        }
        this.firstAdjustedIndex = Math.min(this.firstAdjustedIndex, n);
        this.lastAdjustedIndex = Math.max(this.lastAdjustedIndex, n);
    }

    private void fireValueChanged(boolean bl) {
        if (this.lastChangedIndex == -1) {
            return;
        }
        int n = this.firstChangedIndex;
        int n2 = this.lastChangedIndex;
        this.firstChangedIndex = Integer.MAX_VALUE;
        this.lastChangedIndex = -1;
        this.fireValueChanged(n, n2, bl);
    }

    private void fireValueChanged(int n, int n2) {
        this.fireValueChanged(n, n2, this.getValueIsAdjusting());
    }

    private void fireValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListSelectionListener == null ? SingleListSelectionAdapter.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) continue;
            if (listSelectionEvent == null) {
                listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
            }
            ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
        }
    }

    private void fireValueChanged() {
        if (this.lastAdjustedIndex == -1) {
            return;
        }
        if (this.getValueIsAdjusting()) {
            this.firstChangedIndex = Math.min(this.firstChangedIndex, this.firstAdjustedIndex);
            this.lastChangedIndex = Math.max(this.lastChangedIndex, this.lastAdjustedIndex);
        }
        int n = this.firstAdjustedIndex;
        int n2 = this.lastAdjustedIndex;
        this.firstAdjustedIndex = Integer.MAX_VALUE;
        this.lastAdjustedIndex = -1;
        this.fireValueChanged(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectionIndexChangeHandler
    implements PropertyChangeListener {
        private SelectionIndexChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            int n = object == null ? -1 : (Integer)object;
            int n2 = object2 == null ? -1 : (Integer)object2;
            SingleListSelectionAdapter.this.setSelectionIndex(n, n2);
        }
    }
}

