/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;

public final class ToggleButtonAdapter
extends JToggleButton.ToggleButtonModel {
    private final ValueModel subject;
    private final Object selectedValue;
    private final Object deselectedValue;

    public ToggleButtonAdapter(ValueModel valueModel) {
        this(valueModel, Boolean.TRUE, Boolean.FALSE);
    }

    public ToggleButtonAdapter(ValueModel valueModel, Object object, Object object2) {
        if (valueModel == null) {
            throw new NullPointerException("The subject must not be null.");
        }
        if (BindingUtils.equals(object, object2)) {
            throw new IllegalArgumentException("The selected value must not equal the deselected value.");
        }
        this.subject = valueModel;
        this.selectedValue = object;
        this.deselectedValue = object2;
        valueModel.addValueChangeListener(new SubjectValueChangeHandler());
        this.updateSelectedState();
    }

    public void setSelected(boolean bl) {
        this.subject.setValue(bl ? this.selectedValue : this.deselectedValue);
        this.updateSelectedState();
    }

    private void updateSelectedState() {
        boolean bl = BindingUtils.equals(this.selectedValue, this.subject.getValue());
        super.setSelected(bl);
    }

    private class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ToggleButtonAdapter.this.updateSelectedState();
        }
    }
}

