/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.IndirectPropertyChangeSupport;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyUnboundException;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class BeanAdapter
extends Model {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final boolean observeChanges;
    private final Map propertyAdapters;
    private IndirectPropertyChangeSupport indirectChangeSupport;
    private Object storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;

    public BeanAdapter(Object object) {
        this(object, false);
    }

    public BeanAdapter(Object object, boolean bl) {
        this(new ValueHolder(object, true), bl);
    }

    public BeanAdapter(ValueModel valueModel) {
        this(valueModel, false);
    }

    public BeanAdapter(ValueModel valueModel, boolean bl) {
        this.beanChannel = valueModel != null ? valueModel : new ValueHolder();
        this.observeChanges = bl;
        this.propertyAdapters = new HashMap();
        this.beanChannel.addValueChangeListener(new BeanChangeHandler());
        Object object = this.getBean();
        if (object != null) {
            if (bl && !BeanUtils.supportsBoundProperties(object.getClass())) {
                throw new PropertyUnboundException("The bean must provide support for listening on property changes as described in section 7.4.5 of the Java Bean Specification.");
            }
            this.observe(object);
        }
        this.storedOldBean = object;
    }

    public Object getBean() {
        return this.beanChannel.getValue();
    }

    public void setBean(Object object) {
        this.beanChannel.setValue(object);
        this.resetChanged();
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    public Object getValue(String string) {
        Object object = this.getBean();
        if (object == null) {
            return null;
        }
        return this.getValue0(object, string);
    }

    public void setValue(String string, Object object) {
        Object object2 = this.getBean();
        if (object2 == null) {
            return;
        }
        this.setValue0(object2, string, object);
    }

    public AbstractValueModel getValueModel(String string) {
        return this.getValueModel(string, null, null);
    }

    public AbstractValueModel getValueModel(String string, String string2, String string3) {
        SimplePropertyAdapter simplePropertyAdapter = this.getPropertyAdapter(string);
        if (simplePropertyAdapter == null) {
            simplePropertyAdapter = new SimplePropertyAdapter(string, string2, string3);
            this.propertyAdapters.put(string, simplePropertyAdapter);
        } else if (!this.equals(string2, simplePropertyAdapter.getterName) || !this.equals(string3, simplePropertyAdapter.setterName)) {
            throw new IllegalArgumentException("You must not invoke this method twice with different getter and/or setter names.");
        }
        return simplePropertyAdapter;
    }

    SimplePropertyAdapter getPropertyAdapter(String string) {
        return (SimplePropertyAdapter)this.propertyAdapters.get(string);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean bl) {
        boolean bl2 = this.isChanged();
        this.changed = bl;
        this.firePropertyChange(PROPERTYNAME_CHANGED, bl2, bl);
    }

    public synchronized void addBeanPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeBeanPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addBeanPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removeBeanPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners() {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners(String string) {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners(string);
    }

    public void release() {
        this.retractInterestFor(this.getBean());
    }

    private void setBean0(Object object, Object object2) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, object, object2);
        this.retractInterestFor(object);
        this.forwardAllAdaptedValuesChanged(object, object2);
        this.resetChanged();
        this.observe(object2);
        this.firePropertyChange(PROPERTYNAME_BEAN, object, object2);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, object, object2);
    }

    private void forwardAllAdaptedValuesChanged(Object object, Object object2) {
        Iterator iterator = new LinkedList(this.propertyAdapters.values()).iterator();
        while (iterator.hasNext()) {
            SimplePropertyAdapter simplePropertyAdapter = (SimplePropertyAdapter)iterator.next();
            simplePropertyAdapter.setBean0(object, object2);
        }
    }

    private void forwardAllAdaptedValuesChanged() {
        Object object = this.getBean();
        Iterator iterator = new LinkedList(this.propertyAdapters.values()).iterator();
        while (iterator.hasNext()) {
            SimplePropertyAdapter simplePropertyAdapter = (SimplePropertyAdapter)iterator.next();
            simplePropertyAdapter.fireChange(object);
        }
    }

    private void observe(Object object) {
        if (!this.observeChanges || object == null) {
            return;
        }
        this.propertyChangeHandler = new PropertyChangeHandler();
        BeanUtils.addPropertyChangeListener(object, this.propertyChangeHandler);
    }

    private void retractInterestFor(Object object) {
        if (!this.observeChanges || object == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(object, this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Object getValue0(Object object, String string) {
        return this.getValue0(object, this.getPropertyDescriptor(object, string));
    }

    private Object getValue0(Object object, PropertyDescriptor propertyDescriptor) {
        return object == null ? null : BeanUtils.getValue(object, propertyDescriptor);
    }

    private void setValue0(Object object, String string, Object object2) {
        this.setValue0(object, this.getPropertyDescriptor(object, string), object2);
    }

    private void setValue0(Object object, PropertyDescriptor propertyDescriptor, Object object2) {
        if (object != null) {
            BeanUtils.setValue(object, propertyDescriptor, object2);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(Object object, String string) {
        return BeanUtils.getPropertyDescriptor(object, string, null, null);
    }

    public final class SimplePropertyAdapter
    extends AbstractValueModel {
        private final String propertyName;
        private final String getterName;
        private final String setterName;
        private PropertyDescriptor cachedPropertyDescriptor;
        private Class cachedBeanClass;

        private SimplePropertyAdapter(String string, String string2, String string3) {
            this.propertyName = string;
            this.getterName = string2;
            this.setterName = string3;
            Object object = BeanAdapter.this.getBean();
            if (object != null) {
                this.getPropertyDescriptor(object);
            }
        }

        public Object getValue() {
            Object object = BeanAdapter.this.getBean();
            return object == null ? null : BeanAdapter.this.getValue0(object, this.getPropertyDescriptor(object));
        }

        public void setValue(Object object) {
            Object object2 = BeanAdapter.this.getBean();
            if (object2 != null) {
                BeanAdapter.this.setValue0(object2, this.getPropertyDescriptor(object2), object);
            }
        }

        private PropertyDescriptor getPropertyDescriptor(Object object) {
            if (this.cachedPropertyDescriptor == null || object.getClass() != this.cachedBeanClass) {
                this.cachedPropertyDescriptor = BeanUtils.getPropertyDescriptor(object, this.propertyName, this.getterName, this.setterName);
                this.cachedBeanClass = object.getClass();
            }
            return this.cachedPropertyDescriptor;
        }

        void fireChange(Object object) {
            Object object2;
            if (object == null) {
                object2 = null;
            } else {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object);
                boolean bl = null == propertyDescriptor.getReadMethod();
                object2 = bl ? null : BeanAdapter.this.getValue0(object, propertyDescriptor);
            }
            this.fireValueChange(null, object2);
        }

        void setBean0(Object object, Object object2) {
            Object object3;
            boolean bl;
            PropertyDescriptor propertyDescriptor;
            Object object4;
            if (object == null) {
                object4 = null;
            } else {
                propertyDescriptor = this.getPropertyDescriptor(object);
                bl = null == propertyDescriptor.getReadMethod();
                Object object5 = object4 = bl ? null : BeanAdapter.this.getValue0(object, propertyDescriptor);
            }
            if (object2 == null) {
                object3 = null;
            } else {
                propertyDescriptor = this.getPropertyDescriptor(object2);
                bl = null == propertyDescriptor.getReadMethod();
                Object object6 = object3 = bl ? null : BeanAdapter.this.getValue0(object2, propertyDescriptor);
            }
            if (object4 != null || object3 != null) {
                this.fireValueChange(object4, object3, true);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BeanAdapter.this.setChanged(true);
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                BeanAdapter.this.forwardAllAdaptedValuesChanged();
            } else {
                SimplePropertyAdapter simplePropertyAdapter = BeanAdapter.this.getPropertyAdapter(string);
                if (simplePropertyAdapter != null) {
                    simplePropertyAdapter.fireValueChange(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), true);
                }
            }
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            BeanAdapter.this.setBean0(BeanAdapter.this.storedOldBean, object);
            BeanAdapter.this.storedOldBean = object;
        }
    }
}

